/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.chat;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.z2six.featheredfriend.network.FFPayloads;
import net.z2six.featheredfriend.world.FeatheredFriendSettingsData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ChatDisabler {
    private static final Logger LOG = LogUtils.getLogger();

    private ChatDisabler() {
    }

    public static void register() {
        try {
            NeoForge.EVENT_BUS.addListener(ChatDisabler::onServerChat);
            LOG.info("[ChatDisabler] Registered ServerChatEvent listener.");
            if (FMLEnvironment.dist == Dist.CLIENT) {
                NeoForge.EVENT_BUS.addListener(ChatDisabler::onClientSendChat);
                NeoForge.EVENT_BUS.addListener(ChatDisabler::onClientReceiveChat);
                LOG.info("[ChatDisabler] Registered ClientChatEvent + ClientChatReceivedEvent listeners.");
            }
        }
        catch (Throwable t) {
            LOG.error("[ChatDisabler] register() failed safely", t);
        }
    }

    private static void onServerChat(@NotNull ServerChatEvent event) {
        try {
            ServerPlayer sender = event.getPlayer();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.serverLevel();
            FeatheredFriendSettingsData settings = FeatheredFriendSettingsData.get(level);
            if (!settings.isChatDisabled()) {
                return;
            }
            String raw = event.getRawText();
            LOG.info("[ChatDisabler] Blocking server chat from '{}' (raw='{}')", (Object)ChatDisabler.safePlayerName((Player)sender), (Object)raw);
            event.setCanceled(true);
            try {
                sender.sendSystemMessage((Component)Component.literal((String)"[FeatheredFriend] Global player chat is disabled on this server."));
            }
            catch (Throwable msgErr) {
                LOG.warn("[ChatDisabler] Failed to message sender='{}': {}", (Object)ChatDisabler.safePlayerName((Player)sender), (Object)msgErr.toString());
            }
        }
        catch (Throwable t) {
            LOG.error("[ChatDisabler] onServerChat failed safely", t);
        }
    }

    private static void onClientSendChat(@NotNull ClientChatEvent event) {
        try {
            if (!ChatDisabler.isChatDisabledClient()) {
                return;
            }
            String message = event.getMessage();
            if (message == null) {
                return;
            }
            if (message.startsWith("/")) {
                LOG.debug("[ChatDisabler] Allowing client command: '{}'", (Object)message);
                return;
            }
            LOG.info("[ChatDisabler] Blocking outgoing client chat message: '{}'", (Object)message);
            event.setCanceled(true);
            try {
                Minecraft mc = Minecraft.getInstance();
                if (mc != null && mc.player != null) {
                    mc.player.displayClientMessage((Component)Component.literal((String)"[FeatheredFriend] Chat is disabled on this server."), true);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            LOG.error("[ChatDisabler] onClientSendChat failed safely", t);
        }
    }

    private static void onClientReceiveChat(@NotNull ClientChatReceivedEvent event) {
        try {
            String msgStr;
            if (!ChatDisabler.isChatDisabledClient()) {
                return;
            }
            Component msg = event.getMessage();
            String string = msgStr = msg == null ? "<null>" : msg.getString();
            if (event instanceof ClientChatReceivedEvent.Player) {
                LOG.debug("[ChatDisabler] Blocking incoming PLAYER chat message: '{}'", (Object)msgStr);
                event.setCanceled(true);
                return;
            }
            if (event instanceof ClientChatReceivedEvent.System) {
                LOG.debug("[ChatDisabler] Allowing incoming SYSTEM message: '{}'", (Object)msgStr);
                return;
            }
            LOG.debug("[ChatDisabler] Blocking incoming UNKNOWN chat type ({}) message: '{}'", (Object)event.getClass().getName(), (Object)msgStr);
            event.setCanceled(true);
        }
        catch (Throwable t) {
            LOG.error("[ChatDisabler] onClientReceiveChat failed safely", t);
        }
    }

    private static boolean isChatDisabledClient() {
        try {
            ServerLevel overworld;
            IntegratedServer server;
            if (FMLEnvironment.dist != Dist.CLIENT) {
                return true;
            }
            if (FFPayloads.ClientState.hasSynced()) {
                boolean v = FFPayloads.ClientState.isChatDisabled();
                LOG.debug("[ChatDisabler] isChatDisabledClient: using synced state -> {}", (Object)v);
                return v;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return true;
            }
            if (mc.hasSingleplayerServer() && (server = mc.getSingleplayerServer()) != null && (overworld = server.overworld()) != null) {
                FeatheredFriendSettingsData data = FeatheredFriendSettingsData.get(overworld);
                boolean v = data.isChatDisabled();
                LOG.debug("[ChatDisabler] isChatDisabledClient: integrated server world value -> {}", (Object)v);
                return v;
            }
            LOG.debug("[ChatDisabler] isChatDisabledClient: not synced yet -> default true");
            return true;
        }
        catch (Throwable t) {
            LOG.error("[ChatDisabler] isChatDisabledClient failed safely", t);
            return true;
        }
    }

    private static String safePlayerName(@NotNull Player player) {
        try {
            return player.getGameProfile().getName();
        }
        catch (Throwable ignored) {
            try {
                return player.getName().getString();
            }
            catch (Throwable ignored2) {
                return "<unknown>";
            }
        }
    }
}

