/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.calendar;

import com.mojang.logging.LogUtils;
import net.z2six.featheredfriend.calendar.CalendarDate;
import net.z2six.featheredfriend.calendar.CalendarDefinition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class FeatheredCalendar {
    private static final Logger LOG = LogUtils.getLogger();

    private FeatheredCalendar() {
    }

    @NotNull
    public static CalendarDate fromGameTime(long gameTime, @NotNull CalendarDefinition definition) {
        try {
            int monthIndex;
            int monthCount;
            int daysPerYear;
            long ticksPerDay = definition.getTicksPerDay();
            if (ticksPerDay <= 0L) {
                LOG.warn("[FeatheredCalendar] ticksPerDay <= 0 ({}), falling back to 24000", (Object)ticksPerDay);
                ticksPerDay = 24000L;
            }
            long absoluteDay = Math.floorDiv(gameTime, ticksPerDay);
            long ticksWithinDay = Math.floorMod(gameTime, ticksPerDay);
            int daysPerMonth = definition.getDaysPerMonth();
            if (daysPerMonth <= 0) {
                LOG.warn("[FeatheredCalendar] daysPerMonth <= 0 ({}), falling back to 28", (Object)daysPerMonth);
                daysPerMonth = 28;
            }
            long yearIndex = (daysPerYear = daysPerMonth * (monthCount = definition.getMonthCount())) <= 0 ? 0L : Math.floorDiv(absoluteDay, daysPerYear);
            long dayOfYear = daysPerYear <= 0 ? 0L : (long)Math.floorMod(absoluteDay, daysPerYear);
            int n = monthIndex = daysPerMonth <= 0 ? 0 : (int)(dayOfYear / (long)daysPerMonth);
            if (monthIndex < 0) {
                monthIndex = 0;
            }
            if (monthIndex >= monthCount) {
                monthIndex = monthCount - 1;
            }
            int dayOfMonthZeroBased = daysPerMonth <= 0 ? 0 : (int)(dayOfYear % (long)daysPerMonth);
            int dayOfMonth = dayOfMonthZeroBased + 1;
            long yearNumber = yearIndex;
            return new CalendarDate(gameTime, absoluteDay, yearIndex, yearNumber, monthIndex, dayOfMonth, ticksWithinDay);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredCalendar] fromGameTime failed, returning default date for 0 AN", t);
            CalendarDefinition def = CalendarDefinition.defaultDefinition();
            return new CalendarDate(0L, 0L, 0L, 0L, 0, 1, 0L);
        }
    }

    @NotNull
    public static String formatDate(long gameTime, @NotNull CalendarDefinition definition) {
        CalendarDate date = FeatheredCalendar.fromGameTime(gameTime, definition);
        return date.format(definition);
    }
}

