/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.calendar;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import net.z2six.featheredfriend.Constants;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CalendarDefinition {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String[] HARD_DEFAULT_MONTHS = new String[]{"Dawnroot", "Blossomwake", "Greengale", "Suncrest", "Stormfall", "Shadowmere", "Frostveil", "Darkrest"};
    private static final String HARD_DEFAULT_YEAR_SUFFIX = "A.N.";
    private static final int HARD_DEFAULT_DAYS_PER_MONTH = 28;
    private static final long HARD_DEFAULT_TICKS_PER_DAY = 24000L;
    private final String[] monthNames;
    private final String yearSuffix;
    private final int daysPerMonth;
    private final long ticksPerDay;

    public CalendarDefinition(@NotNull String[] monthNames, @NotNull String yearSuffix, int daysPerMonth, long ticksPerDay) {
        String[] validatedMonths = CalendarDefinition.validateMonths(monthNames);
        String validatedSuffix = CalendarDefinition.validateYearSuffix(yearSuffix);
        int validatedDaysPerMonth = CalendarDefinition.validateDaysPerMonth(daysPerMonth);
        long validatedTicksPerDay = CalendarDefinition.validateTicksPerDay(ticksPerDay);
        this.monthNames = validatedMonths;
        this.yearSuffix = validatedSuffix;
        this.daysPerMonth = validatedDaysPerMonth;
        this.ticksPerDay = validatedTicksPerDay;
        LOG.debug("[CalendarDefinition] Created with months={} daysPerMonth={} suffix='{}' ticksPerDay={}", new Object[]{Arrays.toString(this.monthNames), this.daysPerMonth, this.yearSuffix, this.ticksPerDay});
    }

    @NotNull
    public static CalendarDefinition defaultDefinition() {
        try {
            return new CalendarDefinition((String[])HARD_DEFAULT_MONTHS.clone(), HARD_DEFAULT_YEAR_SUFFIX, 28, 24000L);
        }
        catch (Throwable t) {
            LOG.error("[CalendarDefinition] defaultDefinition() failed; using ultra-safe fallback", t);
            return new CalendarDefinition(new String[]{"Month1"}, HARD_DEFAULT_YEAR_SUFFIX, 28, 24000L);
        }
    }

    @NotNull
    public String getEraSuffix() {
        return this.getYearSuffix();
    }

    private static String @NotNull [] validateMonths(String @NotNull [] input) {
        try {
            if (input.length == 0) {
                LOG.warn("[CalendarDefinition] monthNames was empty; using hard default months");
                return (String[])HARD_DEFAULT_MONTHS.clone();
            }
            String[] copy = new String[input.length];
            for (int i = 0; i < input.length; ++i) {
                String raw = input[i];
                if (raw == null || raw.isBlank()) {
                    LOG.warn("[CalendarDefinition] monthNames[{}] was blank/null; replacing with 'Month{}'", (Object)i, (Object)(i + 1));
                    copy[i] = "Month" + (i + 1);
                    continue;
                }
                copy[i] = raw;
            }
            return copy;
        }
        catch (Throwable t) {
            LOG.error("[CalendarDefinition] validateMonths failed; using hard default months", t);
            return (String[])HARD_DEFAULT_MONTHS.clone();
        }
    }

    @NotNull
    private static String validateYearSuffix(@NotNull String input) {
        try {
            if (input.isBlank()) {
                LOG.warn("[CalendarDefinition] yearSuffix was blank; using hard default '{}'", (Object)HARD_DEFAULT_YEAR_SUFFIX);
                return HARD_DEFAULT_YEAR_SUFFIX;
            }
            return input;
        }
        catch (Throwable t) {
            LOG.error("[CalendarDefinition] validateYearSuffix failed; using hard default '{}'", (Object)HARD_DEFAULT_YEAR_SUFFIX, (Object)t);
            return HARD_DEFAULT_YEAR_SUFFIX;
        }
    }

    private static int validateDaysPerMonth(int value) {
        try {
            if (value <= 0) {
                LOG.warn("[CalendarDefinition] daysPerMonth={} invalid; using hard default {}", (Object)value, (Object)28);
                return 28;
            }
            return value;
        }
        catch (Throwable t) {
            LOG.error("[CalendarDefinition] validateDaysPerMonth failed; using hard default {}", (Object)28, (Object)t);
            return 28;
        }
    }

    private static long validateTicksPerDay(long value) {
        try {
            if (value <= 0L) {
                LOG.warn("[CalendarDefinition] ticksPerDay={} invalid; using hard default {}", (Object)value, (Object)24000L);
                return 24000L;
            }
            return value;
        }
        catch (Throwable t) {
            LOG.error("[CalendarDefinition] validateTicksPerDay failed; using hard default {}", (Object)24000L, (Object)t);
            return 24000L;
        }
    }

    public int getMonthCount() {
        return this.monthNames.length;
    }

    @NotNull
    public String[] getMonthNames() {
        return (String[])this.monthNames.clone();
    }

    @NotNull
    public String getMonthName(int index) {
        if (index < 0 || index >= this.monthNames.length) {
            LOG.warn("[CalendarDefinition] getMonthName: index {} out of range (0..{}); clamping", (Object)index, (Object)(this.monthNames.length - 1));
            int clamped = Math.max(0, Math.min(index, this.monthNames.length - 1));
            return this.monthNames[clamped];
        }
        return this.monthNames[index];
    }

    @NotNull
    public String getYearSuffix() {
        return this.yearSuffix;
    }

    public int getDaysPerMonth() {
        return this.daysPerMonth;
    }

    public long getTicksPerDay() {
        return this.ticksPerDay;
    }

    public int getDaysPerYear() {
        return this.daysPerMonth * this.monthNames.length;
    }

    public long getTicksPerYear() {
        return this.ticksPerDay * (long)this.getDaysPerYear();
    }

    @NotNull
    public String formatDate(int dayOfMonth, int monthIndex, int year) {
        String month = this.getMonthName(monthIndex);
        int safeDay = Math.max(1, Math.min(dayOfMonth, this.daysPerMonth));
        return "Day " + safeDay + " of " + month + ", " + year + " " + this.yearSuffix;
    }

    public String toString() {
        return "CalendarDefinition{months=" + Arrays.toString(this.monthNames) + ", yearSuffix='" + this.yearSuffix + "', daysPerMonth=" + this.daysPerMonth + ", ticksPerDay=" + this.ticksPerDay + "}";
    }

    static {
        Constants.LOG.debug("[CalendarDefinition] Class loaded");
    }
}

