/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.calendar;

import com.mojang.logging.LogUtils;
import net.z2six.featheredfriend.calendar.CalendarDefinition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CalendarDate {
    private static final Logger LOG = LogUtils.getLogger();
    private final long gameTime;
    private final long absoluteDay;
    private final long yearIndex;
    private final long year;
    private final int monthIndex;
    private final int dayOfMonth;
    private final long ticksWithinDay;

    public CalendarDate(long gameTime, long absoluteDay, long yearIndex, long year, int monthIndex, int dayOfMonth, long ticksWithinDay) {
        this.gameTime = gameTime;
        this.absoluteDay = absoluteDay;
        this.yearIndex = yearIndex;
        this.year = year;
        this.monthIndex = monthIndex;
        this.dayOfMonth = dayOfMonth;
        this.ticksWithinDay = ticksWithinDay;
        LOG.debug("[CalendarDate] Created: gameTime={} absoluteDay={} yearIndex={} monthIndex={} dayOfMonth={} ticksWithinDay={}", new Object[]{gameTime, absoluteDay, yearIndex, monthIndex, dayOfMonth, ticksWithinDay});
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public long getAbsoluteDay() {
        return this.absoluteDay;
    }

    public long getYearIndex() {
        return this.yearIndex;
    }

    public long getYear() {
        return this.year;
    }

    public int getMonthIndex() {
        return this.monthIndex;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public long getTicksWithinDay() {
        return this.ticksWithinDay;
    }

    @NotNull
    public String format(@NotNull CalendarDefinition definition) {
        String monthName = definition.getMonthName(this.monthIndex);
        String era = definition.getEraSuffix();
        return "Day " + this.dayOfMonth + " of " + monthName + ", " + this.year + " " + era;
    }

    public String toString() {
        return "CalendarDate{gameTime=" + this.gameTime + ", absoluteDay=" + this.absoluteDay + ", yearIndex=" + this.yearIndex + ", year=" + this.year + ", monthIndex=" + this.monthIndex + ", dayOfMonth=" + this.dayOfMonth + ", ticksWithinDay=" + this.ticksWithinDay + "}";
    }
}

