/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend;

import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.z2six.featheredfriend.CommonClass;
import net.z2six.featheredfriend.chat.ChatDisabler;
import net.z2six.featheredfriend.client.FFClientSyncEvents;
import net.z2six.featheredfriend.client.FFKeyBindings;
import net.z2six.featheredfriend.client.FFNeoForgeClient;
import net.z2six.featheredfriend.client.particle.FFClientParticles;
import net.z2six.featheredfriend.client.raven.RavenClientEvents;
import net.z2six.featheredfriend.command.FeatheredFriendCommands;
import net.z2six.featheredfriend.config.FFCalendarConfig;
import net.z2six.featheredfriend.config.FFClientConfig;
import net.z2six.featheredfriend.events.FFPlayerEvents;
import net.z2six.featheredfriend.network.FFNetwork;
import net.z2six.featheredfriend.network.FFPayloads;
import net.z2six.featheredfriend.registry.FFCreativeTabsNeoForge;
import net.z2six.featheredfriend.registry.FFNeoForgeEntities;
import net.z2six.featheredfriend.registry.FFNeoForgeItems;
import net.z2six.featheredfriend.registry.FFNeoForgeMenus;
import net.z2six.featheredfriend.registry.FFNeoForgeParticles;
import net.z2six.featheredfriend.server.FFServerSyncEvents;
import net.z2six.featheredfriend.world.RavenCourierRuntime;
import net.z2six.featheredfriend.world.RavenSpawnEvents;
import net.z2six.featheredfriend.world.TamedRavenScrollWatcher;
import org.slf4j.Logger;

@Mod(value="featheredfriend")
public class FeatheredFriend {
    private static final Logger LOG = LogUtils.getLogger();

    public FeatheredFriend(IEventBus modEventBus) {
        LOG.info("[FeatheredFriend] Initializing NeoForge side");
        try {
            CommonClass.init();
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] CommonClass.init() failed", t);
        }
        try {
            FFCalendarConfig.register();
            LOG.info("[FeatheredFriend] Registered FFCalendarConfig (SERVER)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] FFCalendarConfig.register() failed", t);
        }
        try {
            FFClientConfig.register();
            LOG.info("[FeatheredFriend] Registered FFClientConfig (CLIENT if applicable)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] FFClientConfig.register() failed", t);
        }
        try {
            FFNeoForgeItems.register(modEventBus);
            FFCreativeTabsNeoForge.register(modEventBus);
            FFNeoForgeMenus.register(modEventBus);
            FFNeoForgeParticles.register(modEventBus);
            LOG.info("[FeatheredFriend] Registered NeoForge registries (items/tabs/menus/particles)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register NeoForge registries", t);
        }
        try {
            FFNeoForgeEntities.register(modEventBus);
            LOG.info("[FeatheredFriend] Registered NeoForge entity registries");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register NeoForge entities", t);
        }
        try {
            modEventBus.addListener(FFNetwork::register);
            LOG.info("[FeatheredFriend] Hooked FFNetwork payload registration listener");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to hook FFNetwork payload registration listener", t);
        }
        try {
            FFPayloads.register(modEventBus);
            LOG.info("[FeatheredFriend] Registered FFPayloads (server settings sync payloads)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register FFPayloads", t);
        }
        try {
            FFNetwork.registerSimpleMessages();
            LOG.info("[FeatheredFriend] FFNetwork.registerSimpleMessages() OK");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] FFNetwork.registerSimpleMessages() failed", t);
        }
        try {
            modEventBus.addListener(FFNeoForgeClient::onRegisterMenuScreens);
            LOG.info("[FeatheredFriend] Hooked client menu screen registration listener");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to hook client menu screen registration", t);
        }
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                modEventBus.addListener(RavenClientEvents::onRegisterRenderers);
                LOG.info("[FeatheredFriend] Hooked Raven renderer registration listener (client only)");
                modEventBus.addListener(FFClientParticles::onRegisterParticleProviders);
                LOG.info("[FeatheredFriend] Hooked particle provider registration listener (client only)");
                FFKeyBindings.register(modEventBus);
                LOG.info("[FeatheredFriend] Registered FFKeyBindings (client only)");
            } else {
                LOG.info("[FeatheredFriend] Skipping client-only listeners on non-client dist");
            }
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to hook client-only listeners", t);
        }
        try {
            FFPlayerEvents.register();
            LOG.info("[FeatheredFriend] Registered FFPlayerEvents (player login -> known-player persistence + broadcast)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register FFPlayerEvents", t);
        }
        try {
            RavenSpawnEvents.register();
            LOG.info("[FeatheredFriend] Hooked RavenSpawnEvents (natural spawning)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to hook RavenSpawnEvents", t);
        }
        try {
            TamedRavenScrollWatcher.register();
            LOG.info("[FeatheredFriend] Registered TamedRavenScrollWatcher");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register TamedRavenScrollWatcher", t);
        }
        try {
            RavenCourierRuntime.register();
            LOG.info("[FeatheredFriend] Registered RavenCourierRuntime");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register RavenCourierRuntime", t);
        }
        try {
            ChatDisabler.register();
            LOG.info("[FeatheredFriend] Registered ChatDisabler");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register ChatDisabler", t);
        }
        try {
            FFServerSyncEvents.registerGameBus();
            LOG.info("[FeatheredFriend] Registered FFServerSyncEvents (server login sync)");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register FFServerSyncEvents", t);
        }
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                FFClientSyncEvents.registerGameBus();
                LOG.info("[FeatheredFriend] Registered FFClientSyncEvents (client requests settings on connect)");
            } else {
                LOG.info("[FeatheredFriend] Skipping FFClientSyncEvents on non-client dist");
            }
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register FFClientSyncEvents", t);
        }
        try {
            FeatheredFriendCommands.register();
            LOG.info("[FeatheredFriend] Registered FeatheredFriendCommands");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriend] Failed to register FeatheredFriendCommands", t);
        }
        LOG.info("[FeatheredFriend] NeoForge initialization complete");
    }
}

