/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.events;

import com.jkvin114.displaydelight.events.InterationManager;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayItems;
import com.jkvin114.displaydelight.init.DisplayTags;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="displaydelight")
public class DisplayEvents {
    @SubscribeEvent
    public static void onCheck(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean placed = false;
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().isEmpty()) {
            placed = InterationManager.tryTakeItemWithBareHand(event.getEntity(), level2, event.getHitVec());
        }
        if (!placed && event.getItemStack().is(DisplayTags.SMALL_PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnSmallPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().is(DisplayTags.PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().is(DisplayTags.DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItem(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (placed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)levelAccessor;
            BlockAssociations.initialize(DisplayItems.GetAll());
        }
    }
}

