/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public record ChainModel(float[] vertices, float[] uvs) {
    public static Builder builder(int initialCapacity) {
        return new Builder(initialCapacity);
    }

    public void render(class_4588 buffer, class_4587 matrices, int bLight0, int bLight1, int sLight0, int sLight1) {
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        int count = this.vertices.length / 3;
        for (int i = 0; i < count; ++i) {
            float f = (float)i % ((float)count / 2.0f) / ((float)count / 2.0f);
            int blockLight = (int)class_3532.method_16439((float)f, (float)bLight0, (float)bLight1);
            int skyLight = (int)class_3532.method_16439((float)f, (float)sLight0, (float)sLight1);
            int light = class_765.method_23687((int)blockLight, (int)skyLight);
            buffer.method_22918(modelMatrix, this.vertices[i * 3], this.vertices[i * 3 + 1], this.vertices[i * 3 + 2]).method_22915(0.8f, 0.8f, 0.8f, 1.0f).method_22913(this.uvs[i * 2], this.uvs[i * 2 + 1]).method_22922(class_4608.field_21444).method_60803(light).method_22914(1.0f, 1.0f, 1.0f);
        }
    }

    public static class Builder {
        private final List<Float> vertices;
        private final List<Float> uvs;
        private int size;

        public Builder(int initialCapacity) {
            this.vertices = new ArrayList<Float>(initialCapacity * 3);
            this.uvs = new ArrayList<Float>(initialCapacity * 2);
        }

        public Builder vertex(Vector3f v) {
            this.vertices.add(Float.valueOf(v.x()));
            this.vertices.add(Float.valueOf(v.y()));
            this.vertices.add(Float.valueOf(v.z()));
            return this;
        }

        public Builder uv(float u, float v) {
            this.uvs.add(Float.valueOf(u));
            this.uvs.add(Float.valueOf(v));
            return this;
        }

        public void next() {
            ++this.size;
        }

        public ChainModel build() {
            if (this.vertices.size() != this.size * 3) {
                ConnectibleChains.LOGGER.error("Wrong count of vertices");
            }
            if (this.uvs.size() != this.size * 2) {
                ConnectibleChains.LOGGER.error("Wrong count of uvs");
            }
            return new ChainModel(this.toFloatArray(this.vertices), this.toFloatArray(this.uvs));
        }

        private float[] toFloatArray(List<Float> floats) {
            float[] array = new float[floats.size()];
            int i = 0;
            for (float f : floats) {
                array[i++] = f;
            }
            return array;
        }
    }
}

