/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.client.render.entity.state.ChainKnotEntityRenderState;
import com.github.legoatoom.connectiblechains.client.render.entity.texture.ChainTextureManager;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.Chainable;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5617;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import net.minecraft.class_9064;
import net.minecraft.class_9691;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ChainKnotEntityRenderer
extends class_897<ChainKnotEntity> {
    private final ChainKnotEntityModel<ChainKnotEntity> model;
    private final ChainRenderer chainRenderer = new ChainRenderer();

    public ChainKnotEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new ChainKnotEntityModel(context.method_32167(ClientInitializer.CHAIN_KNOT));
    }

    public ChainRenderer getChainRenderer() {
        return this.chainRenderer;
    }

    public class_2960 getTexture(ChainKnotEntity entity) {
        return null;
    }

    public ChainKnotEntityRenderState createRenderState() {
        return new ChainKnotEntityRenderState();
    }

    public void render(ChainKnotEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        ChainKnotEntityRenderState state = this.createRenderState();
        this.updateRenderState(entity, state, tickDelta);
        this.render(entity, state, matrices, vertexConsumers, light, tickDelta);
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public void render(ChainKnotEntity entity, ChainKnotEntityRenderState state, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta) {
        matrices.method_22903();
        matrices.method_22904(0.0, 0.7, 0.0);
        matrices.method_22905(0.8333333f, 1.0f, 0.8333333f);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(this.model.method_23500(this.getKnotTexture(state.sourceItem)));
        this.model.method_60879(matrices, vertexConsumer, light, class_4608.field_21444);
        matrices.method_22909();
        HashSet<ChainKnotEntityRenderState.ChainData> chainDataSet = state.chainDataSet;
        for (ChainKnotEntityRenderState.ChainData chainData : chainDataSet) {
            this.renderChainLink(matrices, vertexConsumers, chainData);
            if (!ConnectibleChains.runtimeConfig.doDebugDraw()) continue;
            this.drawDebugVector(matrices, chainData.startPos, chainData.endPos, vertexConsumers.getBuffer((class_1921)class_1921.field_21695));
        }
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            matrices.method_22903();
            class_5250 holdingCount = class_2561.method_43470((String)("C: " + chainDataSet.size()));
            this.method_3926((class_1297)entity, (class_2561)holdingCount, matrices, vertexConsumers, light, tickDelta);
            matrices.method_22909();
        }
    }

    private void renderChainLink(class_4587 matrices, class_4597 vertexConsumerProvider, ChainKnotEntityRenderState.ChainData chainData) {
        class_243 offset = chainData.offset;
        class_243 startPos = chainData.startPos;
        class_243 endPos = chainData.endPos;
        class_1792 sourceItem = chainData.sourceItem;
        int chainedEntityBlockLight = chainData.chainedEntityBlockLight;
        int chainHolderBlockLight = chainData.chainHolderBlockLight;
        int chainedEntitySkyLight = chainData.chainedEntitySkyLight;
        int chainHolderSkyLight = chainData.chainHolderSkyLight;
        class_1921 entityCutout = class_1921.method_23578((class_2960)this.getChainTexture(sourceItem));
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(entityCutout);
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
        }
        matrices.method_22903();
        matrices.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        Vector3f chainVec = new Vector3f((float)(endPos.field_1352 - startPos.field_1352), (float)(endPos.field_1351 - startPos.field_1351), (float)(endPos.field_1350 - startPos.field_1350));
        float angleY = -((float)Math.atan2(chainVec.z(), chainVec.x()));
        matrices.method_22907(new Quaternionf().rotateXYZ(0.0f, angleY, 0.0f));
        CatenaryRenderer renderer = this.getCatenaryRenderer(sourceItem);
        if (chainData.useBaked) {
            ChainRenderer.BakeKey key = new ChainRenderer.BakeKey(startPos, endPos);
            this.chainRenderer.renderBaked(renderer, vertexConsumer, matrices, key, chainVec, chainedEntityBlockLight, chainHolderBlockLight, chainedEntitySkyLight, chainHolderSkyLight);
        } else {
            this.chainRenderer.render(renderer, vertexConsumer, matrices, chainVec, chainedEntityBlockLight, chainHolderBlockLight, chainedEntitySkyLight, chainHolderSkyLight);
        }
        matrices.method_22909();
    }

    private void drawDebugVector(class_4587 matrices, class_243 startPos, class_243 endPos, class_4588 buffer) {
        if (startPos == null) {
            return;
        }
        Matrix4f modelMat = matrices.method_23760().method_23761();
        class_243 vec = endPos.method_1020(startPos);
        class_243 normal = vec.method_1029();
        buffer.method_22918(modelMat, 0.0f, 0.0f, 0.0f).method_1336(0, 255, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        buffer.method_22918(modelMat, (float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350).method_1336(255, 0, 0, 255).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
    }

    public void updateRenderState(ChainKnotEntity entity, ChainKnotEntityRenderState state, float tickDelta) {
        HashSet<ChainKnotEntityRenderState.ChainData> result = new HashSet<ChainKnotEntityRenderState.ChainData>(entity.getChainDataSet().size());
        for (Chainable.ChainData chainData : new HashSet<Chainable.ChainData>(entity.getChainDataSet())) {
            class_243 dstPos;
            class_1297 chainHolder = entity.getChainHolder(chainData);
            if (chainHolder == null) continue;
            class_243 offset = new class_243(0.0, 0.3, 0.0);
            class_243 srcPos = entity.getChainPos(tickDelta);
            if (chainHolder instanceof ChainKnotEntity) {
                ChainKnotEntity chainKnotEntity = (ChainKnotEntity)chainHolder;
                dstPos = chainKnotEntity.getChainPos(tickDelta);
            } else {
                dstPos = chainHolder.method_30951(tickDelta);
            }
            class_2338 blockPosOfStart = class_2338.method_49638((class_2374)entity.method_5836(tickDelta));
            class_2338 blockPosOfEnd = class_2338.method_49638((class_2374)chainHolder.method_5836(tickDelta));
            class_1937 world = entity.method_37908();
            ChainKnotEntityRenderState.ChainData renderChainData = new ChainKnotEntityRenderState.ChainData();
            renderChainData.offset = offset;
            renderChainData.startPos = srcPos;
            renderChainData.endPos = dstPos;
            renderChainData.chainedEntityBlockLight = world.method_8314(class_1944.field_9282, blockPosOfStart);
            renderChainData.chainHolderBlockLight = world.method_8314(class_1944.field_9282, blockPosOfEnd);
            renderChainData.chainedEntitySkyLight = world.method_8314(class_1944.field_9284, blockPosOfStart);
            renderChainData.chainHolderSkyLight = world.method_8314(class_1944.field_9284, blockPosOfEnd);
            renderChainData.sourceItem = chainData.sourceItem;
            renderChainData.useBaked = chainHolder instanceof class_9691;
            result.add(renderChainData);
        }
        state.chainDataSet = result;
        state.sourceItem = entity.getSourceItem();
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            state.nameLabelPos = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_53831());
        }
    }

    private ChainTextureManager getTextureManager() {
        return ClientInitializer.getInstance().getChainTextureManager();
    }

    private class_2960 getKnotTexture(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return this.getTextureManager().getKnotTexture(id);
    }

    private class_2960 getChainTexture(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return this.getTextureManager().getChainTexture(id);
    }

    private CatenaryRenderer getCatenaryRenderer(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return this.getTextureManager().getCatenaryRenderer(id);
    }
}

