/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.client;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ClientPackProvider
extends DynamicClientResourceProvider {
    public ClientPackProvider() {
        super(SuppSquared.res("dynamic_assets"), PackGenerationStrategy.CACHED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("supplementaries", "minecraft");
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            StaticResource isItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(SuppSquared.res("item_shelf_suppsquared_shelf")));
            StaticResource isBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(SuppSquared.res("item_shelf_suppsquared_shelf")));
            StaticResource isModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(SuppSquared.res("item_shelves/suppsquared_shelf")));
            SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                String id = Utils.getID((Block)sign).getPath();
                if (wood == VanillaWoodTypes.OAK) {
                    return;
                }
                try {
                    sink.addSimilarJsonResource(manager, isBlockState, s -> s.replace("item_shelf_suppsquared_shelf", id).replace("suppsquared_shelf", id.replace("item_shelf_", "")));
                    sink.addSimilarJsonResource(manager, isModel, s -> s.replace("item_shelf_suppsquared_shelf", id).replace("suppsquared_shelf", id.replace("item_shelf_", "")));
                    sink.addSimilarJsonResource(manager, isItemModel, s -> s.replace("item_shelf_suppsquared_shelf", id).replace("suppsquared_shelf", id.replace("item_shelf_", "")));
                }
                catch (Exception ex) {
                    SuppSquared.LOGGER.error("Failed to generate models for {} : {}", sign, (Object)ex);
                }
            });
        });
        executor.accept((manager, sink) -> {
            try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"item/item_shelf"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("item/item_shelves/" + Utils.getID((Block)sign).getPath().replace("item_shelf_", ""));
                    sink.addTextureIfNotPresent(manager, textureRes, () -> {
                        TextureImage newImage = null;
                        Item signItem = wood.getItemOfThis("sign");
                        if (signItem != null) {
                            try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                                 TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"item/hanging_signs/sign_board_mask"));){
                                List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                                newImage = respriter.recolor(targetPalette);
                            }
                            catch (Exception vanillaSign2) {
                                // empty catch block
                            }
                        }
                        if (newImage == null) {
                            try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                                Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                                newImage = respriter.recolor(targetPalette);
                            }
                            catch (Exception ex) {
                                SuppSquared.LOGGER.error("Failed to generate Sign Post item texture for for {} : {}", sign, (Object)ex);
                            }
                        }
                        return newImage;
                    });
                });
            }
            catch (Exception ex) {
                SuppSquared.LOGGER.error("Could not generate any Item Shelves item texture : ", (Throwable)ex);
            }
        });
        executor.accept((manager, sink) -> {
            try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/item_shelf"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("block/item_shelves/" + Utils.getID((Block)sign).getPath().replace("item_shelf_", ""));
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        try (TextureImage newImage = respriter.recolor(palette);){
                            sink.addTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        SuppSquared.LOGGER.error("Failed to generate Item Shelf block texture for for {} : {}", sign, (Object)ex);
                    }
                });
            }
            catch (Exception ex) {
                SuppSquared.LOGGER.error("Could not generate any Item Shelf block texture : ", (Throwable)ex);
            }
        });
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        SuppSquared.ITEM_SHELVES.forEach((type, block) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.suppsquared.item_shelf", (BlockType)type, (Block)block));
    }
}

