/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.compat.watervision.WVCompat;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.screens.PlayListScreen;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import me.srrapero720.waterframes.common.screens.widgets.WidgetClickableArea;
import me.srrapero720.waterframes.common.screens.widgets.WidgetPairTable;
import me.srrapero720.waterframes.common.screens.widgets.WidgetStatusIcon;
import me.srrapero720.waterframes.common.screens.widgets.WidgetURLTextField;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiCheckButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiCounterDecimal;
import team.creative.creativecore.common.gui.control.simple.GuiIcon;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiSeekBar;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiStateButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.parser.DoubleValueParser;
import team.creative.creativecore.common.gui.parser.IntValueParser;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.type.Color;

public class DisplayScreen
extends GuiLayer {
    protected static final float SCALE = 0.0625f;
    protected static final int WIDTH = 225;
    protected static final int HEIGHT = 210;
    public final DisplayTile tile;
    private final GuiLabel url_l = new GuiLabel("media_label").setTranslate("waterframes.gui.label.url");
    private final GuiIcon rot_i = (GuiIcon)new GuiIcon("r_icon", IconStyles.ROTATION).setSquared(true).setTooltip("waterframes.gui.icon.rotation");
    private final GuiIcon vis_i = (GuiIcon)new GuiIcon("t_icon", IconStyles.TRANSPARENCY).setSquared(true).setTooltip("waterframes.gui.icon.alpha");
    private final GuiIcon bright_i = (GuiIcon)new GuiIcon("b_icon", IconStyles.BRIGHTNESS).setSquared(true).setTooltip("waterframes.gui.icon.brightness");
    private final GuiIcon render_i = (GuiIcon)new GuiIcon("r_icon", IconStyles.RENDER_DISTANCE).setSquared(true).setTooltip("waterframes.gui.icon.render_distance");
    private final GuiIcon project_i = (GuiIcon)new GuiIcon("pd_icon", IconStyles.PROJECTION_DISTANCE).setSquared(true).setTooltip("waterframes.gui.icon.projection_distance");
    private final GuiIcon vol_i = (GuiIcon)new GuiIcon("v_icon", IconStyles.VOLUME).setSquared(true).setTooltip("waterframes.gui.icon.volume");
    private final GuiIcon vol_min_i = (GuiIcon)new GuiIcon("v_min_icon", IconStyles.VOLUME_RANGE_MIN).setSquared(true).setTooltip("waterframes.gui.icon.volume_min");
    private final GuiIcon vol_max_i = (GuiIcon)new GuiIcon("v_max_icon", IconStyles.VOLUME_RANGE_MAX).setSquared(true).setTooltip("waterframes.gui.icon.volume_max");
    public final GuiButtonIcon save;
    public final WidgetURLTextField url;
    public final GuiCounterDecimal widthField;
    public final GuiCounterDecimal heightField;
    public final GuiSlider rotation;
    public final GuiSteppedSlider alpha;
    public final GuiSteppedSlider brightness;
    public final GuiSteppedSlider render_distance;
    public final GuiSlider projection_distance;
    public final GuiCheckBox show_model;
    public final GuiCheckBox lit;
    private final GuiCheckBox shaderMode;
    public final GuiCheckButtonIcon mirror;
    public final GuiCheckButtonIcon loop;
    public final GuiCheckButtonIcon playback;
    public final GuiControl stop;
    public final GuiStateButtonIcon audio_offset;
    public final GuiButtonIcon watervision;
    public final GuiButtonIcon reload;
    public final GuiSeekBar seekbar;
    public final GuiCheckBox flip_x;
    public final GuiCheckBox flip_y;
    public final GuiSteppedSlider volume;
    public final GuiSteppedSlider volume_min;
    public final GuiSteppedSlider volume_max;
    public final WidgetClickableArea pos_view;

    public DisplayScreen(final DisplayTile tile) {
        super("display_screen", 225, 210);
        this.setAlign(Align.STRETCH);
        this.flow = GuiFlow.STACK_Y;
        this.tile = tile;
        this.url = new WidgetURLTextField(this.tile);
        GuiButtonIcon resize_y = new GuiButtonIcon("rs_y", IconStyles.EXPAND_Y, this::resizeYOnRatio);
        GuiButtonIcon resize_x = new GuiButtonIcon("rs_x", IconStyles.EXPAND_X, this::resizeXOnRation);
        this.widthField = new GuiCounterDecimal("width", BigDecimal.valueOf(tile.data.getWidth()).setScale(2, RoundingMode.CEILING).doubleValue(), 0.1, (double)DisplaysConfig.maxWidth(), ControlFormatting.CLICKABLE_NO_PADDING);
        this.widthField.setSpacing(0).setStep(0.0625).setAlign(Align.STRETCH).setVAlign(VAlign.STRETCH);
        this.widthField.buttons.setVAlign(VAlign.STRETCH);
        this.widthField.get("value").setTooltip("waterframes.common.width");
        this.widthField.add((GuiControl)resize_y.setDim(16, 16));
        this.heightField = new GuiCounterDecimal("height", BigDecimal.valueOf(tile.data.getHeight()).setScale(2, RoundingMode.CEILING).doubleValue(), 0.1, (double)DisplaysConfig.maxHeight(), ControlFormatting.CLICKABLE_NO_PADDING);
        this.heightField.setSpacing(0).setStep(0.0625).setAlign(Align.STRETCH).setVAlign(VAlign.STRETCH);
        this.heightField.buttons.setVAlign(VAlign.STRETCH);
        this.heightField.get("value").setTooltip("waterframes.common.height");
        this.heightField.add((GuiControl)resize_x.setDim(16, 16));
        this.flip_x = new GuiCheckBox("flip_x", tile.data.flipX);
        this.flip_y = new GuiCheckBox("flip_y", tile.data.flipY);
        this.flip_x.setTranslate("waterframes.gui.flip_x");
        this.flip_y.setTranslate("waterframes.gui.flip_y");
        this.rotation = new GuiSlider("rotation", (double)tile.data.rotation, 0.0, 360.0, DoubleValueParser.ANGLE);
        this.alpha = new GuiSteppedSlider("alpha", tile.data.alpha, 0, 255, (v, max) -> Math.round((v != 0 && max != 0 ? (float)v / (float)max : 0.0f) * 100.0f) + "%");
        this.brightness = new GuiSteppedSlider("brightness", tile.data.brightness, 0, 255, (v, max) -> Math.round((v != 0 && max != 0 ? (float)v / (float)max : 0.0f) * 100.0f) + "%");
        this.render_distance = new GuiSteppedSlider("render_distance", tile.data.renderDistance, 4, DisplaysConfig.maxRenDis(), IntValueParser.BLOCKS);
        this.projection_distance = new GuiSlider("projection_distance", (double)tile.data.projectionDistance, 4.0, (double)DisplaysConfig.maxProjDis(), DoubleValueParser.BLOCKS);
        this.audio_offset = new GuiStateButtonIcon("audio_offset", new Icon[]{IconStyles.AUDIO_POS_BLOCK, IconStyles.AUDIO_POS_PICTURE, IconStyles.AUDIO_POS_CENTER});
        this.audio_offset.setControlFormatting(ControlFormatting.CLICKABLE_NO_PADDING).setState(tile.data.getAudioPosition().ordinal()).setShadow(Color.NONE);
        this.mirror = new GuiCheckButtonIcon("render_both", IconStyles.MIRROR_ON, IconStyles.MIRROR_OFF, tile.data.renderBothSides);
        this.mirror.setControlFormatting(ControlFormatting.CLICKABLE_NO_PADDING).setShadow(Color.NONE);
        this.show_model = new GuiCheckBox("show_model", tile.canHideModel() && tile.isVisible());
        this.show_model.setTranslate("waterframes.gui.show_model");
        this.lit = new GuiCheckBox("lit", tile.canHideModel() && tile.isVisible());
        this.lit.setTranslate("waterframes.gui.lit");
        this.shaderMode = new GuiCheckBox("shader_mode", false);
        this.shaderMode.setTranslate("waterframes.gui.shader_mode");
        this.shaderMode.consumeChanged(DisplaysConfig::shaderMode);
        this.pos_view = new WidgetClickableArea("pos_view", tile.data.getPosX(), tile.data.getPosY());
        this.playback = new GuiCheckButtonIcon("playback", IconStyles.PLAY, IconStyles.PAUSE, tile.data.paused, button -> tile.setPause(true, !tile.data.paused));
        this.stop = new GuiButtonIcon("stop", IconStyles.STOP, button -> tile.setStop(true));
        this.loop = new GuiCheckButtonIcon("loop", IconStyles.REPEAT_ON, IconStyles.REPEAT_OFF, tile.data.loop, button -> tile.loop(true, !tile.data.loop));
        this.volume = new GuiSteppedSlider("volume", tile.data.volume, 0, DisplaysConfig.maxVol(), (v, max) -> v + "%");
        this.volume_min = new GuiSteppedSlider("volume_min_range", tile.data.minVolumeDistance, 0, Math.min(tile.data.maxVolumeDistance, DisplaysConfig.maxVolDis()), IntValueParser.BLOCKS);
        this.volume_max = new GuiSteppedSlider("volume_max_range", tile.data.maxVolumeDistance, 0, DisplaysConfig.maxVolDis(), IntValueParser.BLOCKS);
        this.volume_max.setMinSlider((GuiSlider)this.volume_min);
        this.seekbar = new GuiSeekBar(this, "seek", () -> tile.data.tick, () -> tile.data.tickMax, LongValueParser.TIME_DURATION_TICK){

            public boolean mouseScrolled(double x, double y, double scrolled) {
                if (scrolled > 0.0) {
                    tile.fastFoward(true);
                } else {
                    tile.rewind(true);
                }
                return true;
            }
        }.setOnTimeUpdate(v -> {
            tile.data.tick = (int)v;
        }).setOnLastTimeUpdate(v -> tile.syncTime(true, (int)v, tile.data.tickMax));
        this.reload = new GuiButtonIcon("reload", IconStyles.RELOAD, x -> tile.imageCache.reload());
        this.reload.setTooltip("waterframes.gui.reload");
        if (this.isClient()) {
            this.reload.setEnabled(this.enableReload());
        }
        this.save = new GuiButtonIcon("save", IconStyles.SAVE, click -> DisplayNetwork.sendServer(new DataSyncPacket(tile.getBlockPos(), DisplayData.build(this, tile))));
        this.save.setTooltip("waterframes.gui.save");
        if (this.isClient() && WVCompat.installed()) {
            this.watervision = new GuiButtonIcon("", IconStyles.VIDEOPLAYER_PLAY, button -> {
                WVCompat.openScreen(tile.data.uri, tile.data.volume);
                tile.setPause(true, true);
            });
            this.watervision.setTooltip("waterframes.gui.videoplayer");
            if (this.isClient()) {
                this.watervision.setEnabled(this.enableWaterVision());
            }
        } else {
            this.watervision = null;
        }
        if (!tile.caps.resizes()) {
            this.setDim(215, 150);
        }
    }

    public boolean isClient() {
        return this.tile.isClient();
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        this.add((GuiControl)new WidgetPairTable((GuiFlow)GuiFlow.STACK_Y, 4).addLeft(new GuiControl[]{this.url_l}).addLeft(!((Boolean)DisplaysConfig.useExperimentalPlaylistMode.get()).booleanValue(), () -> ((WidgetURLTextField)this.url).setExpandableX()).addLeft((Boolean)DisplaysConfig.useExperimentalPlaylistMode.get(), () -> new GuiButton("open_uri", mouse -> this.getIntegratedParent().openLayer((GuiLayer)new PlayListScreen(this.tile))).setTitle((Component)Component.literal((String)"Select Playlist")).setExpandableX()).addRight(new GuiControl[]{new WidgetStatusIcon("", IconStyles.STATUS_OK, this.tile).setDim(30, 30)}));
        this.add(this.tile.caps.resizes(), () -> new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.STRETCH).add(this.widthField.setExpandableX()).add(this.heightField.setExpandableX()).add((GuiControl)new GuiParent((GuiFlow)GuiFlow.STACK_Y).add((GuiControl)this.flip_x).add((GuiControl)this.flip_y)).setSpacing(4));
        this.add(new GuiParent().setDim(-1, 4));
        this.add(new WidgetPairTable((GuiFlow)GuiFlow.STACK_Y, 2).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.vis_i).add(this.alpha.setDim(-1, 12).setExpandableX()).add((GuiControl)this.bright_i).add(this.brightness.setDim(-1, 12).setExpandableX()).setVAlign(VAlign.CENTER)}).addLeft(this.tile.caps.resizes(), () -> new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.rot_i).add(this.rotation.setDim(-1, 12).setExpandableX()).setVAlign(VAlign.CENTER)).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.render_i).add(this.render_distance.setDim(-1, 12).setExpandableX()).add(this.tile.caps.renderBehind(), () -> this.mirror.setDim(23, 12)).setVAlign(VAlign.CENTER)}).addLeft(this.tile.caps.projects(), () -> new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.project_i).add(this.projection_distance.setDim(-1, 12).setExpandableX()).add((GuiControl)this.audio_offset.setDim(23, 12)).setVAlign(VAlign.CENTER)).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add(this.tile.canHideModel(), () -> {
            this.show_model.set(this.tile.isVisible());
            return this.show_model;
        }).add(!DisplaysConfig.forceLightOnPlay(), () -> {
            this.lit.set(this.tile.data.lit);
            return this.lit;
        }).add(this.isClient(), () -> {
            this.shaderMode.set(DisplaysConfig.shaderMode());
            return this.shaderMode;
        }).setSpacing(6)}).applyOnLeft(column -> column.setSpacing(2)).addRight(this.tile.caps.resizes(), () -> this.pos_view.setDim(64, 64)).addRight(!this.tile.caps.resizes(), () -> this.flip_x).addRight(!this.tile.caps.resizes(), () -> this.flip_y).setAlignRight(Align.RIGHT).setSpacing(8).setExpandableY());
        this.add((GuiControl)new WidgetPairTable((GuiFlow)GuiFlow.STACK_Y, 2).spaceBetween().addLeft(new GuiParent((GuiFlow)GuiFlow.STACK_X).add(WVCompat.installed(), () -> this.watervision.setDim(12, 12)).setExpandableX()).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.loop.setDim(12, 12)).add((GuiControl)this.playback.setDim(16, 12).setSquared(true)).add(this.stop.setDim(12, 12))}).applyOnLeft(column -> column.setDim(60, -1)).addRight(new GuiControl[]{new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.RIGHT).add((GuiControl)this.vol_i.setDim(12, 12).setIcon(IconStyles.getVolumeIcon(this.tile.data.volume, this.tile.data.muted))).add(this.volume.setDim(-1, 16).setExpandableX()).setVAlign(VAlign.CENTER)}).addRight(new GuiControl[]{new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.RIGHT).add((GuiControl)this.vol_min_i).add(this.volume_min.setDim(63, 12).setExpandableX()).add((GuiControl)this.vol_max_i).add(this.volume_max.setDim(63, 12).setExpandableX())}).setVAlignRight(VAlign.CENTER));
        this.add((GuiControl)new GuiParent((GuiFlow)GuiFlow.STACK_X).add(this.seekbar.setDim(-1, 18).setExpandableX()).add((GuiControl)this.reload.setDim(14, 14)).add(this.save.setDim(28, 14).setSquared(true).setEnabled(DisplaysConfig.canSave(this.getPlayer(), this.url.getText()))));
        if (this.watervision != null) {
            this.watervision.setEnabled(this.enableWaterVision());
        }
    }

    public void resizeYOnRatio(int click) {
        if (click == 0 && this.tile.display != null) {
            this.heightField.setValue((double)this.getYSizeRatio());
        }
    }

    public void resizeXOnRation(int click) {
        if (click == 0 && this.tile.display != null) {
            this.widthField.setValue((double)this.getXSizeRatio());
        }
    }

    public float getYSizeRatio() {
        if (this.tile.display == null) {
            return -1.0f;
        }
        return (float)((double)this.tile.display.height() / ((double)this.tile.display.width() / this.widthField.getValue()));
    }

    public float getXSizeRatio() {
        if (this.tile.display == null) {
            return -1.0f;
        }
        return (float)((double)this.tile.display.width() / ((double)this.tile.display.height() / this.heightField.getValue()));
    }

    public void tick() {
        super.tick();
        if (this.tile.isRemoved()) {
            this.closeTopLayer();
            return;
        }
        if (!this.isClient()) {
            return;
        }
        float ySize = this.getYSizeRatio();
        this.widthField.get("rs_y").setTooltip(List.of(DisplayScreen.translatable((String)"waterframes.gui.resize.y"), ySize == -1.0f ? DisplayScreen.translatable((String)"waterframes.gui.resize.no_size") : DisplayScreen.translatable((String)"waterframes.gui.resize.size", (Object[])new Object[]{ChatFormatting.AQUA.toString() + ySize})));
        float xSize = this.getXSizeRatio();
        this.heightField.get("rs_x").setTooltip(List.of(DisplayScreen.translatable((String)"waterframes.gui.resize.x"), ySize == -1.0f ? DisplayScreen.translatable((String)"waterframes.gui.resize.no_size") : DisplayScreen.translatable((String)"waterframes.gui.resize.size", (Object[])new Object[]{ChatFormatting.AQUA.toString() + xSize})));
        this.playback.setState(this.tile.data.paused);
        this.playback.setTooltip(Collections.singletonList(DisplayScreen.translatable((String)"waterframes.gui.playback", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + DisplayScreen.translate((String)("waterframes.common." + (this.playback.value ? "paused" : "playing")))})));
        this.loop.setTooltip(Collections.singletonList(DisplayScreen.translatable((String)"waterframes.gui.loop", (Object[])new Object[]{String.valueOf(this.loop.value ? ChatFormatting.GREEN : ChatFormatting.RED) + DisplayScreen.translate((String)("waterframes.common." + this.loop.value))})));
        this.mirror.setTooltip(List.of(DisplayScreen.translatable((String)"waterframes.gui.mirror.1"), DisplayScreen.translatable((String)"waterframes.gui.mirror.2", (Object[])new Object[]{String.valueOf(this.mirror.value ? ChatFormatting.GREEN : ChatFormatting.RED) + DisplayScreen.translate((String)("waterframes.common." + this.mirror.value))})));
        this.audio_offset.setTooltip(List.of(DisplayScreen.translatable((String)"waterframes.gui.audio_pos.1"), DisplayScreen.translatable((String)"waterframes.gui.audio_pos.2", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + DisplayScreen.translate((String)("waterframes.gui.audio_pos.states." + this.audio_offset.getState()))})));
        this.vol_i.setIcon(IconStyles.getVolumeIcon(this.volume.getIntValue(), this.tile.data.muted));
        this.save.setEnabled(DisplaysConfig.canSave(this.getPlayer(), this.url.getText()));
        this.reload.setEnabled(this.enableReload());
    }

    public boolean enableReload() {
        return this.tile.imageCache != null && !this.url.getText().isEmpty() && this.tile.data.hasUri() && this.tile.data.getUri().equals(WaterFrames.createURI(this.url.getText()));
    }

    public boolean enableWaterVision() {
        return this.tile.data.hasUri() && this.tile.imageCache != null && this.tile.imageCache.getStatus() == ImageCache.Status.READY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BACKGROUND;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BORDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle getStyle() {
        return ScreenStyles.DISPLAYS;
    }
}

