/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.Display;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class DisplayRenderer
implements BlockEntityRenderer<DisplayTile> {
    private static final Function<ResourceLocation, RenderType> BLOCK_TRANSLUCENT_CULL_CUSTOM_TEXTURE = Util.memoize(p_173198_ -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173198_, false, false)).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.NO_OVERLAY).createCompositeState(false);
        return RenderType.create((String)"block_translucent_cull_custom_texture", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
    });
    private final BlockEntityRendererProvider.Context context;

    public DisplayRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public boolean shouldRenderOffScreen(DisplayTile tile) {
        return tile.data.getWidth() > 16.0f || tile.data.getHeight() > 16.0f;
    }

    public boolean shouldRender(DisplayTile tile, @NotNull Vec3 cameraPos) {
        BlockPos tilePos = tile.getBlockPos().relative(tile.getDirection(), (int)tile.data.projectionDistance);
        return Vec3.atCenterOf((Vec3i)tilePos).closerThan((Position)cameraPos, (double)tile.data.renderDistance);
    }

    public AABB getRenderBoundingBox(DisplayTile tile) {
        return tile.getRenderBox().getBB(tile.getBlockPos());
    }

    public void render(DisplayTile tile, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int b;
        Display display = tile.activeDisplay();
        if (display == null || !DisplaysConfig.keepsRendering()) {
            return;
        }
        display.preRender();
        Direction direction = tile.getDirection();
        AlignedBox box = tile.getRenderBox();
        boolean invertedFace = tile.caps.invertedFace(tile);
        BoxFace boxFace = BoxFace.get((Facing)Facing.get((Direction)(invertedFace ? direction.getOpposite() : direction)));
        Facing facing = boxFace.facing;
        packedLight = 0xF000F0;
        boolean front = !tile.caps.projects() || tile.data.renderBothSides;
        boolean back = tile.caps.projects() || tile.data.renderBothSides;
        boolean flipX = tile.caps.projects() != tile.data.flipX;
        boolean flipY = tile.data.flipY;
        int g = b = tile.data.brightness;
        int r = b;
        int a = tile.data.alpha;
        pose.pushPose();
        pose.translate(0.5, 0.5, 0.5);
        pose.mulPose(facing.rotation().rotation((float)Math.toRadians(-tile.data.rotation)));
        pose.translate(-0.5, -0.5, -0.5);
        if (tile.caps.growMax(tile, facing, invertedFace)) {
            box.setMax(facing.axis, box.getMax(facing.axis) + tile.caps.growSize());
        } else {
            box.setMin(facing.axis, box.getMin(facing.axis) - tile.caps.growSize());
        }
        if (display.isLoading()) {
            this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
        } else if (display.canRender()) {
            ResourceLocation tex = display.getTextureId();
            if (tex != null) {
                this.vertex(pose, bufferSource, box, boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, tex);
            }
            if (display.isBuffering()) {
                this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
            }
        }
        pose.popPose();
    }

    public void vertex(PoseStack pose, MultiBufferSource source, AlignedBox box, BoxFace boxface, Facing facing, int packedLight, int packedOverlay, boolean front, boolean back, boolean flipX, boolean flipY, int r, int g, int b, int a, ResourceLocation texture) {
        BoxCorner corner;
        int i;
        VertexConsumer builder = source.getBuffer(DisplaysConfig.shaderMode() ? RenderType.entityTranslucentCull((ResourceLocation)texture) : BLOCK_TRANSLUCENT_CULL_CUSTOM_TEXTURE.apply(texture));
        if (front) {
            for (i = 0; i < boxface.corners.length; ++i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
        if (back) {
            for (i = boxface.corners.length - 1; i >= 0; --i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
    }

    public void vertex(PoseStack pose, VertexConsumer builder, AlignedBox box, BoxFace boxface, BoxCorner corner, Facing facing, int packedLight, int packedOverlay, boolean flipX, boolean flipY, int r, int g, int b, int a) {
        Vec3i normal = facing.normal;
        builder.addVertex(pose.last().pose(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).setColor(r, g, b, a).setUv(corner.isFacing(boxface.getTexU()) != flipX ? 1.0f : 0.0f, corner.isFacing(boxface.getTexV()) != flipY ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose.last(), (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    public AlignedBox getLoadingBox(DisplayTile tile, AlignedBox parent, Facing facing) {
        float height;
        AlignedBox box = new AlignedBox(parent);
        Axis one = facing.one();
        Axis two = facing.two();
        float width = box.getSize(one);
        if (width > (height = box.getSize(two))) {
            float subtracts = (width - height) / 2.0f;
            float marginSubstract = height / 4.0f;
            box.setMin(one, box.getMin(one) + subtracts + marginSubstract);
            box.setMax(one, box.getMax(one) - subtracts - marginSubstract);
            box.setMin(two, box.getMin(two) + marginSubstract);
            box.setMax(two, box.getMax(two) - marginSubstract);
        } else if (height > width) {
            float subtracts = (height - width) / 2.0f;
            float marginSubstract = width / 4.0f;
            box.setMin(two, box.getMin(two) + subtracts + marginSubstract);
            box.setMax(two, box.getMax(two) - subtracts - marginSubstract);
            box.setMin(one, box.getMin(one) + marginSubstract);
            box.setMax(one, box.getMax(one) - marginSubstract);
        }
        if (facing.positive) {
            box.setMax(facing.axis, parent.getMax(facing.axis) + (tile.caps.projects() ? -0.001f : 0.001f));
        } else {
            box.setMin(facing.axis, parent.getMin(facing.axis) - (tile.caps.projects() ? -0.001f : 0.001f));
        }
        return box;
    }
}

