/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.blueprint;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.block.door.FramedDoorBlock;
import xfacthd.framedblocks.common.data.blueprint.auxdata.DoorAuxBlueprintData;

public final class DoorCopyBehaviour
implements BlueprintCopyBehaviour {
    @Override
    public BlueprintData writeToBlueprint(Level level, BlockPos pos, BlockState state, FramedBlockEntity be) {
        boolean top = state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER;
        BlockPos posTwo = top ? pos.below() : pos.above();
        BlueprintData dataOne = be.writeToBlueprint();
        BlueprintData dataTwo = BlueprintData.EMPTY;
        BlockEntity blockEntity = DoorCopyBehaviour.getSecondBlockEntity(level, posTwo);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity beTwo = (FramedBlockEntity)blockEntity;
            dataTwo = beTwo.writeToBlueprint();
        }
        BlueprintData mainData = top ? dataTwo : dataOne;
        BlueprintData secData = top ? dataOne : dataTwo;
        return mainData.withAuxData(new DoorAuxBlueprintData(secData));
    }

    @Override
    public CamoList getCamos(BlueprintData data) {
        BlueprintData secData = DoorCopyBehaviour.getSecondData(data);
        return data.camos().concat(secData.camos());
    }

    @Override
    public int getGlowstoneCount(BlueprintData data) {
        int count = BlueprintCopyBehaviour.super.getGlowstoneCount(data);
        if (DoorCopyBehaviour.getSecondData(data).glowing()) {
            ++count;
        }
        return count;
    }

    @Override
    public int getIntangibleCount(BlueprintData data) {
        return 0;
    }

    @Override
    public int getReinforcementCount(BlueprintData data) {
        int count = BlueprintCopyBehaviour.super.getReinforcementCount(data);
        if (DoorCopyBehaviour.getSecondData(data).reinforced()) {
            ++count;
        }
        return count;
    }

    @Override
    public void postProcessPaste(Level level, BlockPos pos, Player player, BlueprintData data, ItemStack dummyStack) {
        BlueprintData secData = DoorCopyBehaviour.getSecondData(data);
        if (secData.isEmpty()) {
            return;
        }
        BlockPos topPos = pos.above();
        BlockEntity blockEntity = DoorCopyBehaviour.getSecondBlockEntity(level, topPos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.applyBlueprintData(secData);
        }
    }

    private static BlockEntity getSecondBlockEntity(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getBlock() instanceof FramedDoorBlock) {
            return level.getBlockEntity(pos);
        }
        return null;
    }

    public static BlueprintData getSecondData(BlueprintData blueprintData) {
        return blueprintData.getAuxDataOrDefault(DoorAuxBlueprintData.EMPTY).data();
    }
}

