/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawGhostIngredientHandler
implements IGhostIngredientHandler<FramingSawWithEncoderScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(FramingSawWithEncoderScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        if (screen.getMenu().isInEncoderMode() && ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack stack = (ItemStack)ingredient.getItemStack().orElseThrow();
            if (FramingSawRecipeCache.get(true).getMaterialValue(stack.getItem()) > 0) {
                return List.of(new InputTarget(screen, 0));
            }
            RecipeHolder<FramingSawRecipe> recipe = screen.getMenu().getRecipes().get(screen.getMenu().getSelectedRecipeIndex()).toVanilla();
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)recipe.value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                if (!additives.get(i).ingredient().test(stack)) continue;
                return List.of(new InputTarget(screen, i + 1));
            }
        }
        return List.of();
    }

    public void onComplete() {
    }

    private record InputTarget(FramingSawWithEncoderScreen screen, int slot, Rect2i area) implements IGhostIngredientHandler.Target<ItemStack>
    {
        public InputTarget(FramingSawWithEncoderScreen screen, int slot) {
            this(screen, slot, new Rect2i(screen.getInputSlotX() - 1, screen.getInputSlotY(slot) - 1, 18, 18));
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(ItemStack stack) {
            this.screen.acceptEncodingInput(this.slot, stack);
        }
    }
}

