/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.common.compat.jade.FramedBlockElement;
import xfacthd.framedblocks.common.compat.jade.JadeCompat;

class FramedBlockComponentProvider
implements IBlockComponentProvider {
    static final FramedBlockComponentProvider INSTANCE = new FramedBlockComponentProvider();

    protected FramedBlockComponentProvider() {
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        Block block = accessor.getBlockState().getBlock();
        if (!(block instanceof IFramedBlock)) {
            return null;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        if (!block2.shouldRenderAsBlockInJadeTooltip()) {
            return null;
        }
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof FramedBlockEntity)) {
            return null;
        }
        FramedBlockEntity blockEntity2 = (FramedBlockEntity)blockEntity;
        return new FramedBlockElement(accessor.getBlockState(), blockEntity2);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity fbe = (FramedBlockEntity)blockEntity;
            if (fbe.getBlockType().isDoubleBlock() && fbe instanceof IFramedDoubleBlockEntity) {
                IFramedDoubleBlockEntity fdbe = (IFramedDoubleBlockEntity)((Object)fbe);
                tooltip.add((Component)Component.translatable((String)JadeCompat.LABEL_CAMO_ONE, (Object[])new Object[]{((CamoContent)fbe.getCamo().getContent()).getCamoName()}));
                tooltip.add((Component)Component.translatable((String)JadeCompat.LABEL_CAMO_TWO, (Object[])new Object[]{((CamoContent)fdbe.getCamoTwo().getContent()).getCamoName()}));
            } else {
                tooltip.add((Component)Component.translatable((String)JadeCompat.LABEL_CAMO, (Object[])new Object[]{((CamoContent)fbe.getCamo().getContent()).getCamoName()}));
            }
        }
    }

    public ResourceLocation getUid() {
        return JadeCompat.ID_FRAMED_BLOCK;
    }
}

