/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slope.FramedConnectingPyramidBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public class FramedStackedPyramidSlabBlock
extends FramedConnectingPyramidBlock
implements IFramedDoubleBlock {
    public FramedStackedPyramidSlabBlock(BlockType type) {
        super(type);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        PillarConnection connection = (PillarConnection)((Object)state.getValue(PropertyHolder.PILLAR_CONNECTION));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState stateOne = Utils.isY(facing) ? (BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB.value()).defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(facing == Direction.DOWN)) : (BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite());
        return new Tuple((Object)stateOne, (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_UPPER_PYRAMID_SLAB.value()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing)).setValue(PropertyHolder.PILLAR_CONNECTION, (Comparable)((Object)connection))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            case Direction.UP -> DoubleBlockTopInteractionMode.SECOND;
            case Direction.DOWN -> DoubleBlockTopInteractionMode.FIRST;
            default -> DoubleBlockTopInteractionMode.EITHER;
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return side == facing.getOpposite() ? SolidityCheck.FIRST : SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (side == facing.getOpposite() || side != facing && edge == facing.getOpposite()) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }
}

