/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.ArrayList;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.model.cache.QuadCacheKey;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.FramedFlowerPotBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedFlowerPotBlockEntity;
import xfacthd.framedblocks.common.compat.amendments.AmendmentsCompat;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlowerPotGeometry
extends Geometry {
    private static final ResourceLocation POT_TEXTURE = Utils.rl("minecraft", "block/flower_pot");
    private static final ResourceLocation DIRT_TEXTURE = Utils.rl("minecraft", "block/dirt");
    private final boolean hanging;
    private final BakedModel hangingPotModel;

    public FramedFlowerPotGeometry(GeometryFactory.Context ctx) {
        this.hanging = AmendmentsCompat.isLoaded() && (Boolean)ctx.state().getValue((Property)PropertyHolder.HANGING) != false;
        this.hangingPotModel = this.hanging ? ctx.modelLookup().get(AmendmentsCompat.Client.HANGING_MODEL_LOCATION) : null;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        if (quad.getDirection() == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).export(quadMap.get(Direction.DOWN));
        } else if (quad.getDirection() == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.625f, 0.6875f, 0.6875f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.375f, 0.375f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.625f, 0.375f, 0.6875f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
        } else if (!Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData data) {
        BlockState potState = FramedFlowerPotBlock.getFlowerPotState(FramedFlowerPotGeometry.getFlowerBlock(data));
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ModelUtils.getRenderTypes(Blocks.DIRT.defaultBlockState(), rand, ModelData.EMPTY), !potState.isAir() ? ModelUtils.getRenderTypes(potState, rand, ModelData.EMPTY) : ChunkRenderTypeSet.none(), this.hanging ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none()});
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType layer) {
        BlockState potState = FramedFlowerPotBlock.getFlowerPotState(FramedFlowerPotGeometry.getFlowerBlock(data));
        if (!potState.isAir()) {
            FramedFlowerPotGeometry.addPlantQuads(quadMap, potState, rand, layer);
        }
        FramedFlowerPotGeometry.addDirtQuads(quadMap, rand, data, layer);
        if (this.hanging && layer == RenderType.cutout()) {
            Utils.forAllDirections(dir -> Utils.copyAll(this.hangingPotModel.getQuads(null, dir, rand, data, null), quadMap.get((Direction)dir)));
        }
    }

    @Override
    public QuadCacheKey makeCacheKey(CamoContent<?> camo, Object ctCtx, ModelData data) {
        return new FlowerPotQuadCacheKey(camo, ctCtx, FramedFlowerPotGeometry.getFlowerBlock(data));
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    private static void addPlantQuads(QuadMap quadMap, BlockState potState, RandomSource rand, RenderType layer) {
        BakedModel potModel = ModelUtils.getModel(potState);
        if (potModel.getRenderTypes(potState, rand, ModelData.EMPTY).contains(layer)) {
            Utils.forAllDirections(dir -> {
                ArrayList<BakedQuad> outQuads = quadMap.get((Direction)dir);
                for (BakedQuad quad : potModel.getQuads(potState, dir, rand, ModelData.EMPTY, layer)) {
                    if (ClientUtils.isTexture(quad, POT_TEXTURE) || ClientUtils.isTexture(quad, DIRT_TEXTURE)) continue;
                    outQuads.add(ModelUtils.invertTintIndex(quad));
                }
            });
        }
    }

    private static void addDirtQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType layer) {
        BakedModel dirtModel = ModelUtils.getModel(Blocks.DIRT.defaultBlockState());
        if (dirtModel.getRenderTypes(Blocks.DIRT.defaultBlockState(), rand, ModelData.EMPTY).contains(layer)) {
            dirtModel.getQuads(Blocks.DIRT.defaultBlockState(), Direction.UP, rand, ModelData.EMPTY, layer).forEach(q -> QuadModifier.of(q).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.25f)).export(quadMap.get(null)));
            FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
            if (fbData != null && !fbData.getCamoContent().canOcclude()) {
                for (BakedQuad quad : dirtModel.getQuads(Blocks.DIRT.defaultBlockState(), Direction.DOWN, rand, ModelData.EMPTY, layer)) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
                }
                Utils.forHorizontalDirections(dir -> {
                    for (BakedQuad quad : dirtModel.getQuads(Blocks.AIR.defaultBlockState(), dir, rand, ModelData.EMPTY, layer)) {
                        QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.25f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
                    }
                });
            }
        }
    }

    private static Block getFlowerBlock(ModelData data) {
        Block flower = (Block)data.get(FramedFlowerPotBlockEntity.FLOWER_BLOCK);
        return flower != null ? flower : Blocks.AIR;
    }

    private record FlowerPotQuadCacheKey(CamoContent<?> camo, Object ctCtx, Block flower) implements QuadCacheKey
    {
    }
}

