/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.util.VectorUtils;
import org.jetbrains.annotations.Nullable;

public class SideAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = AttributeKey.create("side", int[]::new);
    private int @Nullable [] sideRef;

    public SideAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        assert (ccrs.model != null);
        this.sideRef = ccrs.model.getAttribute(attributeKey);
        if (ccrs.model.hasAttribute(attributeKey)) {
            return this.sideRef != null;
        }
        ccrs.pipeline.addDependency(ccrs.normalAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.side = this.sideRef != null ? this.sideRef[ccrs.vertexIndex] : VectorUtils.findSide(ccrs.normal);
    }
}

