/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.VoxelShapeBlockHitResult;
import codechicken.lib.render.particle.CustomBreakingParticle;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CustomParticleHandler {
    public static boolean handleLandingEffects(ServerLevel world, BlockPos pos, LivingEntity entity, int numParticles) {
        PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1, entity.level().registryAccess());
        packet.writePos(pos);
        packet.writeVector(Vector3.fromEntity((Entity)entity));
        packet.writeVarInt(numParticles);
        packet.sendToPlayer((ServerPlayer)entity);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleRunningEffects(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockHitResult traceResult = new BlockHitResult(entity.position().add(0.0, 1.0, 0.0), Direction.UP, pos, false);
        BlockModelShaper modelShapes = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BakedModel model = modelShapes.getBlockModel(state);
        if (model instanceof IModelParticleProvider) {
            ModelData modelData = Objects.requireNonNull(world.getModelDataManager()).getAt(pos);
            ParticleEngine particleManager = Minecraft.getInstance().particleEngine;
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (BlockAndTintGetter)world, pos, modelData));
            TextureAtlasSprite rolledSprite = (TextureAtlasSprite)sprites.get(world.random.nextInt(sprites.size()));
            double x = entity.getX() + ((double)world.random.nextFloat() - 0.5) * (double)entity.getBbWidth();
            double y = entity.getBoundingBox().minY + 0.1;
            double z = entity.getZ() + ((double)world.random.nextFloat() - 0.5) * (double)entity.getBbWidth();
            particleManager.add((Particle)new CustomBreakingParticle((ClientLevel)world, x, y, z, -entity.getDeltaMovement().x * 4.0, 1.5, -entity.getDeltaMovement().z * 4.0, rolledSprite));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleHitEffects(BlockState state, Level world, HitResult traceResult, ParticleEngine manager) {
        if (traceResult instanceof BlockHitResult) {
            BlockHitResult hit = (BlockHitResult)traceResult;
            BlockPos pos = hit.getBlockPos();
            BlockModelShaper modelShapes = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
            BakedModel model = modelShapes.getBlockModel(state);
            if (model instanceof IModelParticleProvider) {
                ModelData modelData = Objects.requireNonNull(world.getModelDataManager()).getAt(pos);
                Cuboid6 bounds = new Cuboid6();
                if (hit instanceof VoxelShapeBlockHitResult) {
                    bounds.set(((VoxelShapeBlockHitResult)hit).shape.bounds());
                } else {
                    bounds.set(state.getShape((BlockGetter)world, pos).bounds());
                }
                bounds = bounds.copy().add(pos);
                Set<TextureAtlasSprite> hitSprites = ((IModelParticleProvider)model).getHitEffects(hit, state, (BlockAndTintGetter)world, pos, modelData);
                ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(hitSprites);
                CustomParticleHandler.addBlockHitEffects(world, bounds, hit.getDirection(), (TextureAtlasSprite)sprites.get(world.random.nextInt(sprites.size())), manager);
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleDestroyEffects(Level world, BlockPos pos, BlockState state, ParticleEngine manager) {
        BlockModelShaper modelShapes = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BakedModel model = modelShapes.getBlockModel(state);
        if (model instanceof IModelParticleProvider) {
            ModelData modelData = Objects.requireNonNull(world.getModelDataManager()).getAt(pos);
            Cuboid6 bounds = new Cuboid6(state.getShape((BlockGetter)world, pos).bounds());
            CustomParticleHandler.addBlockDestroyEffects(world, bounds.add(pos), new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getDestroyEffects(state, (BlockAndTintGetter)world, pos, modelData)), manager);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLandingEffects(Level world, BlockPos pos, BlockState state, Vector3 entityPos, int numParticles) {
        BlockHitResult traceResult = new BlockHitResult(new Vec3(entityPos.x, (double)(pos.getY() + 1), entityPos.z), Direction.UP, pos, false);
        ParticleEngine manager = Minecraft.getInstance().particleEngine;
        Random randy = new Random();
        BlockModelShaper modelShapes = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BakedModel model = modelShapes.getBlockModel(state);
        if (model instanceof IModelParticleProvider) {
            ModelData modelData = Objects.requireNonNull(world.getModelDataManager()).getAt(pos);
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (BlockAndTintGetter)world, pos, modelData));
            double speed = 0.15f;
            if (numParticles != 0) {
                for (int i = 0; i < numParticles; ++i) {
                    double mX = randy.nextGaussian() * speed;
                    double mY = randy.nextGaussian() * speed;
                    double mZ = randy.nextGaussian() * speed;
                    manager.add((Particle)CustomBreakingParticle.newLandingParticle((ClientLevel)world, entityPos.x, entityPos.y, entityPos.z, mX, mY, mZ, (TextureAtlasSprite)sprites.get(randy.nextInt(sprites.size()))));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockHitEffects(Level world, Cuboid6 bounds, Direction side, TextureAtlasSprite icon, ParticleEngine particleManager) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.random.nextDouble();
        diff.y *= world.random.nextDouble();
        diff.z *= world.random.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == Direction.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == Direction.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == Direction.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == Direction.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == Direction.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == Direction.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        particleManager.add(new CustomBreakingParticle((ClientLevel)world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).setPower(0.2f).scale(0.6f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockDestroyEffects(Level world, Cuboid6 bounds, List<TextureAtlasSprite> icons, ParticleEngine particleManager) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).ceil();
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    particleManager.add((Particle)new CustomBreakingParticle((ClientLevel)world, x, y, z, x - center.x, y - center.y, z - center.z, icons.get(world.random.nextInt(icons.size()))));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

