/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketCustomChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketCustomChannel.class);
    public final ResourceLocation channel;
    @Nullable
    private String version;
    private boolean optional;
    @Nullable
    private ICustomPacketHandler.IClientConfigurationPacketHandler clientConfiguration;
    @Nullable
    private ICustomPacketHandler.IServerConfigurationPacketHandler serverConfiguration;
    @Nullable
    private ICustomPacketHandler.IClientPacketHandler client;
    @Nullable
    private ICustomPacketHandler.IServerPacketHandler server;

    public PacketCustomChannel(ResourceLocation channel) {
        this.channel = channel;
    }

    public PacketCustomChannel versioned(String version) {
        this.version = version;
        return this;
    }

    public PacketCustomChannel optional() {
        this.optional = true;
        return this;
    }

    public PacketCustomChannel clientConfiguration(Supplier<Supplier<ICustomPacketHandler.IClientConfigurationPacketHandler>> supplier) {
        if (FMLEnvironment.dist.isClient()) {
            this.clientConfiguration = supplier.get().get();
        }
        return this;
    }

    public PacketCustomChannel client(Supplier<Supplier<ICustomPacketHandler.IClientPacketHandler>> supplier) {
        if (FMLEnvironment.dist.isClient()) {
            this.client = supplier.get().get();
        }
        return this;
    }

    public PacketCustomChannel server(Supplier<Supplier<ICustomPacketHandler.IServerPacketHandler>> supplier) {
        this.server = supplier.get().get();
        return this;
    }

    public void init(IEventBus modBus) {
        modBus.addListener(this::onRegisterPayloadHandlerEvent);
    }

    private void onRegisterPayloadHandlerEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.channel.getNamespace());
        if (this.optional) {
            registrar = registrar.optional();
        }
        if (this.version != null) {
            registrar = registrar.versioned(this.version);
        }
        registrar = registrar.executesOn(HandlerThread.NETWORK);
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(this.channel);
        StreamCodec codec = StreamCodec.of((buf, p) -> buf.writeBytes(p.data(), 0, p.data().writerIndex()), buf -> {
            RegistryAccess registryAccess;
            if (buf instanceof RegistryFriendlyByteBuf) {
                RegistryFriendlyByteBuf b = (RegistryFriendlyByteBuf)buf;
                registryAccess = b.registryAccess();
            } else {
                registryAccess = null;
            }
            RegistryAccess access = registryAccess;
            return new PacketCustom.Pkt((CustomPacketPayload.Type<PacketCustom.Pkt>)type, access, buf.readBytes(buf.readableBytes()));
        });
        registrar.playBidirectional(type, codec, (payload, context) -> {
            switch (context.flow()) {
                case CLIENTBOUND: {
                    if (this.client == null) break;
                    PacketCustomChannel.enqueue(context, payload, () -> this.client.handlePacket(new PacketCustom((PacketCustom.Pkt)payload), Minecraft.getInstance()));
                    break;
                }
                case SERVERBOUND: {
                    if (this.server == null) break;
                    PacketCustomChannel.enqueue(context, payload, () -> this.server.handlePacket(new PacketCustom((PacketCustom.Pkt)payload), (ServerPlayer)context.player()));
                }
            }
        });
        registrar.configurationToClient(type, codec, (payload, context) -> {
            if (this.clientConfiguration != null) {
                PacketCustomChannel.enqueue(context, payload, () -> this.clientConfiguration.handlePacket(new PacketCustom((PacketCustom.Pkt)payload), Minecraft.getInstance()));
            }
        });
    }

    private static void enqueue(IPayloadContext context, PacketCustom.Pkt payload, Runnable runnable) {
        context.enqueueWork(() -> {
            try {
                runnable.run();
            }
            finally {
                payload.data().release();
            }
        }).exceptionally(ex -> {
            LOGGER.error("Error processing packet on channel {}", (Object)payload.type().id(), ex);
            return null;
        });
    }
}

