/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.transfer;

import earth.terrarium.pastel.inventories.CraftingTabletScreenHandler;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.transfer.GatedRecipeTransferInfo;

public class CraftingTabletRecipeTransferHandler
implements IRecipeTransferHandler<CraftingTabletScreenHandler, RecipeHolder<PedestalRecipe>> {
    public final PedestalTier tier;
    public final RecipeType<RecipeHolder<PedestalRecipe>> recipeType;
    public final IRecipeTransferHandler<CraftingTabletScreenHandler, RecipeHolder<PedestalRecipe>> wrappedHandler;

    public CraftingTabletRecipeTransferHandler(PedestalTier tier, IRecipeTransferHandlerHelper transferHelper) {
        this.tier = tier;
        this.recipeType = CraftingTabletRecipeTransferHandler.getRecipeType(tier);
        this.wrappedHandler = transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new RecipeTransferInfo(this.recipeType));
    }

    public static RecipeType<RecipeHolder<PedestalRecipe>> getRecipeType(PedestalTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case PedestalTier.BASIC -> PastelJEI.PEDESTAL_BASIC;
            case PedestalTier.SIMPLE -> PastelJEI.PEDESTAL_SIMPLE;
            case PedestalTier.ADVANCED -> PastelJEI.PEDESTAL_ADVANCED;
            case PedestalTier.COMPLEX -> PastelJEI.PEDESTAL_COMPLEX;
        };
    }

    public Class<CraftingTabletScreenHandler> getContainerClass() {
        return CraftingTabletScreenHandler.class;
    }

    public Optional<MenuType<CraftingTabletScreenHandler>> getMenuType() {
        return Optional.of(PastelScreenHandlerTypes.CRAFTING_TABLET);
    }

    public RecipeType<RecipeHolder<PedestalRecipe>> getRecipeType() {
        return this.recipeType;
    }

    public IRecipeTransferError transferRecipe(CraftingTabletScreenHandler container, RecipeHolder<PedestalRecipe> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        return this.wrappedHandler.transferRecipe((AbstractContainerMenu)container, recipeHolder, () -> this.filterSlots(recipeSlots), player, maxTransfer, doTransfer);
    }

    public List<IRecipeSlotView> filterSlots(IRecipeSlotsView recipeSlots) {
        List original = recipeSlots.getSlotViews();
        ArrayList<IRecipeSlotView> filtered = new ArrayList<IRecipeSlotView>();
        int inputCount = 0;
        for (IRecipeSlotView slot : original) {
            if (slot.getRole() == RecipeIngredientRole.INPUT) {
                if (inputCount >= 9) continue;
                ++inputCount;
            }
            filtered.add(slot);
        }
        return filtered;
    }

    public class RecipeTransferInfo
    extends GatedRecipeTransferInfo<CraftingTabletScreenHandler, PedestalRecipe> {
        public RecipeTransferInfo(RecipeType<RecipeHolder<PedestalRecipe>> recipeType) {
            super(CraftingTabletScreenHandler.class, PastelScreenHandlerTypes.CRAFTING_TABLET, recipeType, 0, 9, 15, 36);
        }

        @Override
        public boolean canHandle(CraftingTabletScreenHandler container, RecipeHolder<PedestalRecipe> recipeHolder) {
            return super.canHandle(container, recipeHolder) && container.getTier().orElse(PedestalTier.BASIC).compareTo((Enum)CraftingTabletRecipeTransferHandler.this.tier) >= 0;
        }
    }
}

