/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.helpers.render.LoreHelper;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class SpiritInstillerRecipeCategory
extends AbstractGatedRecipeCategory<SpiritInstillerRecipe> {
    public static final Component TITLE = Component.translatable((String)"block.pastel.spirit_instiller");

    public SpiritInstillerRecipeCategory() {
        super(PastelJEI.SPIRIT_INSTILLER, TITLE);
    }

    @Override
    public int getHeight() {
        return 45;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SpiritInstillerRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        SpiritInstillerRecipe recipe = (SpiritInstillerRecipe)recipeHolder.value();
        List ingredients = recipe.getIngredientStacks();
        this.addItem(builder, RecipeIngredientRole.INPUT, 31, 1, ((IngredientStack)ingredients.get(0)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 11, 1, ((IngredientStack)ingredients.get(1)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 51, 1, ((IngredientStack)ingredients.get(2)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 31, 18, PastelBlocks.SPIRIT_INSTILLER.toStack(), visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 11, 18, PastelBlocks.ITEM_BOWL_CALCITE.toStack(), visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 51, 18, PastelBlocks.ITEM_BOWL_CALCITE.toStack(), visible);
        ItemStack stack = recipe.getResultItem((HolderLookup.Provider)this.registryAccess());
        if (recipe instanceof SpawnerChangeRecipe) {
            SpawnerChangeRecipe spawnerChange = (SpawnerChangeRecipe)recipe;
            LoreHelper.setLore((ItemStack)stack, (Component)spawnerChange.getOutputLoreText());
        }
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 105, 10, stack, (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<SpiritInstillerRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            SpiritInstillerRecipe recipe = (SpiritInstillerRecipe)recipeHolder.value();
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getCraftingTime() * 50)), 73, 10);
        }
    }

    @Override
    public void draw(RecipeHolder<SpiritInstillerRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            SpiritInstillerRecipe recipe = (SpiritInstillerRecipe)recipeHolder.value();
            Font font = this.font();
            Component timeComponent = this.getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
            guiGraphics.drawString(font, timeComponent, this.getWidth() / 2 - font.width((FormattedText)timeComponent) / 2, 36, 0x3F3F3F, false);
        }
    }
}

