/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.inventories.PedestalScreen;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.CyclingDrawable;
import thelm.jeidrawables.gui.render.IngredientDrawable;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class PedestalRecipeCategory
extends AbstractGatedRecipeCategory<PedestalRecipe> {
    public static final Component TITLE_BASIC = Component.translatable((String)"block.pastel.pedestal");
    public static final Component TITLE_SIMPLE = Component.translatable((String)"multiblock.pastel.pedestal_simple");
    public static final Component TITLE_ADVANCED = Component.translatable((String)"multiblock.pastel.pedestal_advanced");
    public static final Component TITLE_COMPLEX = Component.translatable((String)"multiblock.pastel.pedestal_complex");
    public static final IDrawable BASIC_ICON = new CyclingDrawable(1000, new IDrawable[]{new IngredientDrawable((Object)PastelBlocks.PEDESTAL_BASIC_TOPAZ.toStack()), new IngredientDrawable((Object)PastelBlocks.PEDESTAL_BASIC_AMETHYST.toStack()), new IngredientDrawable((Object)PastelBlocks.PEDESTAL_BASIC_CITRINE.toStack())});
    public final PedestalTier tier;
    public final int powderSlotCount;
    public final ResourceLocation background;
    public final ResourceDrawable[] inputSlots;
    public final ResourceDrawable[] powderSlots;
    public final ResourceDrawable outputSlot;
    public final ResourceDrawable tierOverlay;

    public PedestalRecipeCategory(PedestalTier tier) {
        super(PedestalRecipeCategory.getRecipeType(tier), PedestalRecipeCategory.getTitle(tier));
        this.tier = tier;
        this.powderSlotCount = tier.getPowderSlotCount();
        this.background = PedestalScreen.getBackgroundTextureForTier((PedestalTier)tier);
        this.inputSlots = new ResourceDrawable[9];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.inputSlots[y * 3 + x] = new ResourceDrawable(this.background, 29 + x * 18, 18 + y * 18, 18, 18);
            }
        }
        int powderSlotU = 88 - this.powderSlotCount * 9;
        this.powderSlots = new ResourceDrawable[this.powderSlotCount];
        for (int i = 0; i < this.powderSlotCount; ++i) {
            this.powderSlots[i] = new ResourceDrawable(this.background, powderSlotU + i * 18, 76, 18, 18);
        }
        this.outputSlot = new ResourceDrawable(this.background, 122, 32, 26, 26);
        this.tierOverlay = new ResourceDrawable(this.background, 200, 0, 40, 16);
    }

    public static RecipeType<RecipeHolder<PedestalRecipe>> getRecipeType(PedestalTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case PedestalTier.BASIC -> PastelJEI.PEDESTAL_BASIC;
            case PedestalTier.SIMPLE -> PastelJEI.PEDESTAL_SIMPLE;
            case PedestalTier.ADVANCED -> PastelJEI.PEDESTAL_ADVANCED;
            case PedestalTier.COMPLEX -> PastelJEI.PEDESTAL_COMPLEX;
        };
    }

    public static Component getTitle(PedestalTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case PedestalTier.BASIC -> TITLE_BASIC;
            case PedestalTier.SIMPLE -> TITLE_SIMPLE;
            case PedestalTier.ADVANCED -> TITLE_ADVANCED;
            case PedestalTier.COMPLEX -> TITLE_COMPLEX;
        };
    }

    @Override
    public int getHeight() {
        return 89;
    }

    @Override
    public IDrawable getIcon() {
        return this.tier == PedestalTier.BASIC ? BASIC_ICON : null;
    }

    @Override
    public boolean isUnlocked(RecipeHolder<PedestalRecipe> recipeHolder) {
        return super.isUnlocked(recipeHolder) && ((PedestalRecipe)recipeHolder.value()).getTier().hasUnlocked((Player)Minecraft.getInstance().player);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PedestalRecipe> recipeHolder, IFocusGroup focuses) {
        int i;
        boolean visible = this.isVisible(recipeHolder);
        PedestalRecipe recipe = (PedestalRecipe)recipeHolder.value();
        int powderSlotX = 1 + this.getWidth() / 2 - this.powderSlotCount * 9;
        ArrayList gridSlots = new ArrayList(9);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                gridSlots.add(this.addSlot(builder, RecipeIngredientRole.INPUT, 7 + x * 18, 1 + y * 18, (IDrawable)this.inputSlots[y * 3 + x], visible));
            }
        }
        List ingredients = recipe.getIngredientStacks();
        for (i = 0; i < ingredients.size(); ++i) {
            ((IIngredientAcceptor)gridSlots.get(recipe.getGridSlotId(i))).addItemStacks(((IngredientStack)ingredients.get(i)).getItems().toList());
        }
        for (i = 0; i < this.powderSlotCount; ++i) {
            IIngredientAcceptor<?> slot = this.addSlot(builder, RecipeIngredientRole.INPUT, powderSlotX + i * 18, 60, (IDrawable)this.powderSlots[i], visible);
            PastelGemstoneColor color = PastelGemstoneColor.values()[i];
            int powderAmount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (powderAmount <= 0) continue;
            slot.addItemStack(new ItemStack((ItemLike)color.getPowder(), powderAmount));
        }
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 101, 19, recipe.getResultItem((HolderLookup.Provider)this.registryAccess()), (IDrawable)this.outputSlot, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<PedestalRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            PedestalRecipe recipe = (PedestalRecipe)recipeHolder.value();
            builder.addDrawable((IDrawable)this.tierOverlay, 88, 38);
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getCraftingTime() * 50)), 67, 19);
            if (recipe.isShapeless()) {
                builder.addDrawable(JEIDrawables.SHAPELESS_ICON, 121, 0);
            }
        }
    }

    @Override
    public void draw(RecipeHolder<PedestalRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            PedestalRecipe recipe = (PedestalRecipe)recipeHolder.value();
            Font font = this.font();
            Component timeComponent = this.getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
            guiGraphics.drawString(font, timeComponent, this.getWidth() / 2 - font.width((FormattedText)timeComponent) / 2, 80, 0x3F3F3F, false);
        }
    }
}

