/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.recipe.InkConvertingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class InkConvertingRecipeCategory
extends AbstractGatedRecipeCategory<InkConvertingRecipe> {
    public static final Component TITLE = Component.translatable((String)"container.pastel.rei.ink_converting.title");

    public InkConvertingRecipeCategory() {
        super(PastelJEI.INK_CONVERTING, TITLE);
    }

    @Override
    public int getHeight() {
        return 20;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<InkConvertingRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        InkConvertingRecipe recipe = (InkConvertingRecipe)recipeHolder.value();
        this.addItem(builder, RecipeIngredientRole.INPUT, 1, 2, (Ingredient)recipe.getIngredients().get(0), (IDrawable)JEIDrawables.SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<InkConvertingRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            builder.addDrawable((IDrawable)JEIDrawables.RECIPE_ARROW, 22, 2);
        }
    }

    @Override
    public void draw(RecipeHolder<InkConvertingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            InkConvertingRecipe recipe = (InkConvertingRecipe)recipeHolder.value();
            Font font = this.font();
            MutableComponent colorComponent = Component.translatable((String)"container.pastel.rei.ink_converting.color", (Object[])new Object[]{recipe.getInkColor().getName()});
            MutableComponent amountComponent = Component.translatable((String)"container.pastel.rei.ink_converting.amount", (Object[])new Object[]{recipe.getInkAmount()});
            guiGraphics.drawString(font, (Component)colorComponent, 50, 1, 0x3F3F3F, false);
            guiGraphics.drawString(font, (Component)amountComponent, 50, 11, 0x3F3F3F, false);
        }
    }
}

