/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class EnchanterRecipeCategory
extends AbstractGatedRecipeCategory<EnchanterCraftingRecipe> {
    public static final Component TITLE = Component.translatable((String)"container.pastel.rei.enchanting.title");
    public static final ResourceLocation BACKGROUND = PastelCommon.locate((String)"textures/gui/container/enchanter.png");
    public static final ResourceDrawable ALTAR = new ResourceDrawable(BACKGROUND, 0, 0, 54, 54);

    public EnchanterRecipeCategory() {
        super(PastelJEI.ENCHANTER, TITLE);
    }

    @Override
    public int getHeight() {
        return 80;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EnchanterCraftingRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        EnchanterCraftingRecipe recipe = (EnchanterCraftingRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        this.addItem(builder, RecipeIngredientRole.INPUT, 113, 7, KnowledgeGemItem.getKnowledgeDropStackWithXP((int)recipe.getRequiredExperience(), (boolean)true), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 113, 53, PastelBlocks.ENCHANTER.toStack(), visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 34, 32, (Ingredient)ingredients.get(0), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 21, 1, (Ingredient)ingredients.get(1), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 47, 1, (Ingredient)ingredients.get(2), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 65, 19, (Ingredient)ingredients.get(3), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 65, 45, (Ingredient)ingredients.get(4), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 47, 63, (Ingredient)ingredients.get(5), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 21, 63, (Ingredient)ingredients.get(6), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 3, 45, (Ingredient)ingredients.get(7), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 3, 19, (Ingredient)ingredients.get(8), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 113, 32, recipe.getResultItem((HolderLookup.Provider)this.registryAccess()), (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<EnchanterCraftingRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            EnchanterCraftingRecipe recipe = (EnchanterCraftingRecipe)recipeHolder.value();
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getCraftingTime(1.0) * 50)), 84, 32);
        }
    }

    @Override
    public void draw(RecipeHolder<EnchanterCraftingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            EnchanterCraftingRecipe recipe = (EnchanterCraftingRecipe)recipeHolder.value();
            ALTAR.draw(guiGraphics, 15, 13);
            Font font = this.font();
            Component timeComponent = this.getTimeComponent(recipe.getCraftingTime(1.0));
            guiGraphics.drawString(font, timeComponent, 69, 71, 0x3F3F3F, false);
        }
    }
}

