/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.recipe.BlockConversionWithChanceRecipe;
import thelm.pasteljei.recipe.category.AbstractUnlockableRecipeCategory;

public class BlockConversionWithChanceRecipeCategory
extends AbstractUnlockableRecipeCategory<BlockConversionWithChanceRecipe> {
    public final ResourceLocation advancement;

    public BlockConversionWithChanceRecipeCategory(RecipeType<BlockConversionWithChanceRecipe> recipeType, Component title, ResourceLocation advancement) {
        super(recipeType, title);
        this.advancement = advancement;
    }

    @Override
    public int getHeight() {
        return 38;
    }

    @Override
    public boolean isUnlocked(BlockConversionWithChanceRecipe recipe) {
        return this.hasAdvancement(this.advancement);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlockConversionWithChanceRecipe recipe, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipe);
        this.addSlot(builder, RecipeIngredientRole.INPUT, 30, 5, (IDrawable)JEIDrawables.SLOT, visible).addIngredientsUnsafe(recipe.inputIngredient());
        this.addSlot(builder, RecipeIngredientRole.OUTPUT, 86, 5, (IDrawable)JEIDrawables.OUTPUT_SLOT, visible).addIngredientsUnsafe(recipe.outputIngredient());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, BlockConversionWithChanceRecipe recipe, IFocusGroup focuses) {
        if (this.isVisible(recipe)) {
            builder.addDrawable((IDrawable)JEIDrawables.RECIPE_ARROW, 53, 5);
        }
    }

    @Override
    public void draw(BlockConversionWithChanceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipe)) {
            Font font = this.font();
            MutableComponent chanceComponent = Component.translatable((String)"container.pastel.rei.chance", (Object[])new Object[]{Float.valueOf(recipe.chance() * 100.0f)});
            guiGraphics.drawString(font, (Component)chanceComponent, this.getWidth() / 2 - font.width((FormattedText)chanceComponent) / 2, 29, 0x3F3F3F, false);
        }
    }

    public ResourceLocation getRegistryName(BlockConversionWithChanceRecipe recipe) {
        ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)recipe.input().getBlock());
        return ResourceLocation.parse((String)"%s/%s/%s".formatted(this.recipeType.getUid(), blockKey.getNamespace(), blockKey.getPath()));
    }
}

