/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrushingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class AnvilCrushingRecipeCategory
extends AbstractGatedRecipeCategory<AnvilCrushingRecipe> {
    public static final Component TITLE = Component.translatable((String)"container.pastel.rei.anvil_crushing.title");
    public static final Component LOW_FORCE = Component.translatable((String)"container.pastel.rei.anvil_crushing.low_force_required");
    public static final Component MEDIUM_FORCE = Component.translatable((String)"container.pastel.rei.anvil_crushing.medium_force_required");
    public static final Component HIGH_FORCE = Component.translatable((String)"container.pastel.rei.anvil_crushing.high_force_required");
    public static final ResourceLocation BACKGROUND = PastelCommon.locate((String)"textures/gui/container/anvil_crushing.png");
    public static final ResourceDrawable WALL = new ResourceDrawable(BACKGROUND, 0, 0, 16, 48);
    public static final ResourceDrawable FALL = new ResourceDrawable(BACKGROUND, 16, 1, 16, 16);

    public AnvilCrushingRecipeCategory() {
        super(PastelJEI.ANVIL_CRUSHING, TITLE);
    }

    @Override
    public int getHeight() {
        return 59;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<AnvilCrushingRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        AnvilCrushingRecipe recipe = (AnvilCrushingRecipe)recipeHolder.value();
        this.addItem(builder, RecipeIngredientRole.INPUT, 32, 30, (Ingredient)recipe.getIngredients().get(0), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 32, 10, new ItemStack((ItemLike)Items.ANVIL), visible);
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 105, 15, recipe.getResultItem((HolderLookup.Provider)this.registryAccess()), (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<AnvilCrushingRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            builder.addDrawable((IDrawable)WALL, 10, 0);
            builder.addDrawable((IDrawable)FALL, 32, 0);
            builder.addDrawable((IDrawable)JEIDrawables.RECIPE_ARROW, 60, 15);
        }
    }

    @Override
    public void draw(RecipeHolder<AnvilCrushingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            AnvilCrushingRecipe recipe = (AnvilCrushingRecipe)recipeHolder.value();
            Font font = this.font();
            MutableComponent xpComponent = Component.translatable((String)"container.pastel.rei.anvil_crushing.plus_xp", (Object[])new Object[]{Float.valueOf(recipe.getExperience())});
            Component forceComponent = this.getForceComponent(recipe);
            guiGraphics.drawString(font, (Component)xpComponent, 126 - font.width((FormattedText)xpComponent), 38, 0x3F3F3F, false);
            guiGraphics.drawString(font, forceComponent, this.getWidth() / 2 - font.width((FormattedText)forceComponent) / 2, 50, 0x3F3F3F, false);
        }
    }

    public Component getForceComponent(AnvilCrushingRecipe recipe) {
        if (recipe.getCrushedItemsPerPointOfDamage() >= 1.0f) {
            return LOW_FORCE;
        }
        if (recipe.getCrushedItemsPerPointOfDamage() >= 0.5f) {
            return MEDIUM_FORCE;
        }
        return HIGH_FORCE;
    }
}

