/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.GatedRecipe;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.pasteljei.recipe.category.AbstractUnlockableRecipeCategory;

public abstract class AbstractGatedRecipeCategory<R extends GatedRecipe<?>>
extends AbstractUnlockableRecipeCategory<RecipeHolder<R>> {
    public AbstractGatedRecipeCategory(RecipeType<RecipeHolder<R>> recipeType, Component title) {
        super(recipeType, title);
    }

    @Override
    public boolean isUnlocked(RecipeHolder<R> recipeHolder) {
        return this.hasAdvancement(((GatedRecipe)recipeHolder.value()).typeAdvancementID()) && this.hasAdvancement(((GatedRecipe)recipeHolder.value()).advancementID().orElse(null));
    }

    @Override
    public boolean isVisible(RecipeHolder<R> recipeHolder) {
        return super.isVisible(recipeHolder) && !((GatedRecipe)recipeHolder.value()).isSecret();
    }

    @Override
    public void draw(RecipeHolder<R> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (!this.isUnlocked(recipeHolder)) {
            this.drawLockedText(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        } else if (((GatedRecipe)recipeHolder.value()).isSecret()) {
            this.drawSecretText(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        }
    }

    public void drawSecretText(RecipeHolder<R> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = this.font();
        if (((GatedRecipe)recipeHolder.value()).getSecretHintText(recipeHolder.id()) == null) {
            guiGraphics.drawString(font, SECRET, this.getWidth() / 2 - font.width((FormattedText)SECRET) / 2, this.getHeight() / 2 - 4, 0x3F3F3F, false);
        } else {
            Component hintComponent = ((GatedRecipe)recipeHolder.value()).getSecretHintText(recipeHolder.id());
            guiGraphics.drawString(font, SECRET_HINT, this.getWidth() / 2 - font.width((FormattedText)SECRET_HINT) / 2, this.getHeight() / 2 - 9, 0x3F3F3F, false);
            guiGraphics.drawString(font, hintComponent, this.getWidth() / 2 - font.width((FormattedText)hintComponent) / 2, this.getHeight() / 2 + 1, 0x3F3F3F, false);
        }
    }
}

