/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.ingredient.subtype;

import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InkStorageItemSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    public Object getSubtypeData(ItemStack ingredient, UidContext context) {
        Item item;
        if (context == UidContext.Ingredient && (item = ingredient.getItem()) instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)item;
            Map storage = inkStorageItem.getEnergyStorage(ingredient).getEnergy();
            List<InkColor> colors = PastelRegistries.INK_COLOR.stream().filter(color -> storage.getOrDefault(color, 0L) > 0L).toList();
            return colors.isEmpty() ? null : colors;
        }
        return "";
    }

    public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
        Item item;
        if (context == UidContext.Ingredient && (item = ingredient.getItem()) instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)item;
            Map storage = inkStorageItem.getEnergyStorage(ingredient).getEnergy();
            return PastelRegistries.INK_COLOR.stream().filter(color -> storage.getOrDefault(color, 0L) > 0L).map(Objects::toString).collect(Collectors.joining(","));
        }
        return "";
    }
}

