/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.gui.handler;

import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.jeidrawables.mixin.AbstractContainerScreenAccessor;

public class ShadowSlotGhostIngredientHandler<T extends AbstractContainerScreen<?>>
implements IGhostIngredientHandler<T> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> ingredient, boolean doStart) {
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            int windowId = gui.getMenu().containerId;
            return gui.getMenu().slots.stream().filter(s -> s instanceof ShadowSlot).filter(s -> s.container instanceof FilterConfigurable.FilterInventory).map(s -> new ShadowSlotTarget(windowId, (Slot)s, ShadowSlotGhostIngredientHandler.getSlotArea(gui, s))).toList();
        }
        return List.of();
    }

    public void onComplete() {
    }

    public static Rect2i getSlotArea(AbstractContainerScreen<?> gui, Slot slot) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)gui;
        return new Rect2i(accessor.jeidas$leftPos() + slot.x, accessor.jeidas$topPos() + slot.y, 16, 16);
    }

    public record ShadowSlotTarget<I>(int windowId, ShadowSlot slot, FilterConfigurable.FilterInventory inventory, Rect2i area) implements IGhostIngredientHandler.Target<I>
    {
        public ShadowSlotTarget(int windowId, Slot slot, Rect2i area) {
            this(windowId, (ShadowSlot)slot, (FilterConfigurable.FilterInventory)slot.container, area);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.inventory.getClicker().clickShadowSlot(this.windowId, (Slot)this.slot, stack);
            }
        }
    }
}

