/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.idols.FirestarterIdolBlock;
import earth.terrarium.pastel.blocks.idols.FreezingIdolBlock;
import earth.terrarium.pastel.data_loaders.NaturesStaffConversionDataLoader;
import earth.terrarium.pastel.inventories.BlackHoleChestScreen;
import earth.terrarium.pastel.inventories.CinderhearthScreen;
import earth.terrarium.pastel.inventories.CinderhearthScreenHandler;
import earth.terrarium.pastel.inventories.CraftingTabletScreen;
import earth.terrarium.pastel.inventories.CraftingTabletScreenHandler;
import earth.terrarium.pastel.inventories.FilteringScreen;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.PedestalScreen;
import earth.terrarium.pastel.inventories.PedestalScreenHandler;
import earth.terrarium.pastel.inventories.PotionWorkshopScreen;
import earth.terrarium.pastel.inventories.PotionWorkshopScreenHandler;
import earth.terrarium.pastel.inventories.QuickNavigationGridScreen;
import earth.terrarium.pastel.recipe.InkConvertingRecipe;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrushingRecipe;
import earth.terrarium.pastel.recipe.cinderhearth.CinderhearthRecipe;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.DragonrotConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.HumusConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.LiquidCrystalConvertingRecipe;
import earth.terrarium.pastel.recipe.fluid_converting.MidnightSolutionConvertingRecipe;
import earth.terrarium.pastel.recipe.fusion_shrine.FusionShrineRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopBrewingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopCraftingRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import earth.terrarium.pastel.recipe.primordial_fire_burning.PrimordialFireBurningRecipe;
import earth.terrarium.pastel.recipe.spirit_instiller.SpiritInstillerRecipe;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.pasteljei.gui.handler.CraftingTabletRecipeClickAreaHandler;
import thelm.pasteljei.gui.handler.OverlayHidingExtraAreaHandler;
import thelm.pasteljei.gui.handler.PedestalRecipeClickAreaHandler;
import thelm.pasteljei.gui.handler.ShadowSlotGhostIngredientHandler;
import thelm.pasteljei.ingredient.subtype.ExperienceStorageItemSubtypeInterpreter;
import thelm.pasteljei.ingredient.subtype.InkStorageItemSubtypeInterpreter;
import thelm.pasteljei.ingredient.subtype.UnstableItemSubtypeInterpreter;
import thelm.pasteljei.recipe.BlockConversionRecipe;
import thelm.pasteljei.recipe.BlockConversionWithChanceRecipe;
import thelm.pasteljei.recipe.category.AnvilCrushingRecipeCategory;
import thelm.pasteljei.recipe.category.BlockConversionRecipeCategory;
import thelm.pasteljei.recipe.category.BlockConversionWithChanceRecipeCategory;
import thelm.pasteljei.recipe.category.CinderhearthRecipeCategory;
import thelm.pasteljei.recipe.category.CrystallarieumRecipeCategory;
import thelm.pasteljei.recipe.category.DescriptiveGatedRecipeCategory;
import thelm.pasteljei.recipe.category.EnchanterRecipeCategory;
import thelm.pasteljei.recipe.category.EnchantmentUpgradeRecipeCategory;
import thelm.pasteljei.recipe.category.FluidConvertingRecipeCategory;
import thelm.pasteljei.recipe.category.FusionShrineRecipeCategory;
import thelm.pasteljei.recipe.category.InkConvertingRecipeCategory;
import thelm.pasteljei.recipe.category.PedestalRecipeCategory;
import thelm.pasteljei.recipe.category.PotionWorkshopRecipeCategory;
import thelm.pasteljei.recipe.category.PrimordialFireBurningRecipeCategory;
import thelm.pasteljei.recipe.category.SpiritInstillerRecipeCategory;
import thelm.pasteljei.recipe.category.TitrationBarrelRecipeCategory;
import thelm.pasteljei.recipe.transfer.CraftingTabletRecipeTransferHandler;
import thelm.pasteljei.recipe.transfer.GatedRecipeTransferInfo;
import thelm.pasteljei.recipe.transfer.PedestalRecipeTransferInfo;

@JeiPlugin
public class PastelJEI
implements IModPlugin {
    public static final ResourceLocation UID = ResourceLocation.parse((String)"pasteljei:pastel");
    public static final Logger LOGGER = LogManager.getLogger();
    public static IJeiHelpers jeiHelpers;
    public static IJeiRuntime jeiRuntime;
    public static final RecipeType<RecipeHolder<PedestalRecipe>> PEDESTAL_BASIC;
    public static final RecipeType<RecipeHolder<PedestalRecipe>> PEDESTAL_SIMPLE;
    public static final RecipeType<RecipeHolder<PedestalRecipe>> PEDESTAL_ADVANCED;
    public static final RecipeType<RecipeHolder<PedestalRecipe>> PEDESTAL_COMPLEX;
    public static final RecipeType<RecipeHolder<AnvilCrushingRecipe>> ANVIL_CRUSHING;
    public static final RecipeType<RecipeHolder<FusionShrineRecipe>> FUSION_SHRINE;
    public static final RecipeType<RecipeHolder<EnchanterCraftingRecipe>> ENCHANTER;
    public static final RecipeType<RecipeHolder<EnchantmentUpgradeRecipe>> ENCHANTMENT_UPGRADE;
    public static final RecipeType<RecipeHolder<PotionWorkshopBrewingRecipe>> POTION_WORKSHOP_BREWING;
    public static final RecipeType<RecipeHolder<PotionWorkshopCraftingRecipe>> POTION_WORKSHOP_CRAFTING;
    public static final RecipeType<RecipeHolder<PotionWorkshopReactingRecipe>> POTION_WORKSHOP_REACTING;
    public static final RecipeType<RecipeHolder<HumusConvertingRecipe>> HUMUS_CONVERTING;
    public static final RecipeType<RecipeHolder<LiquidCrystalConvertingRecipe>> LIQUID_CRYSTAL_CONVERTING;
    public static final RecipeType<RecipeHolder<MidnightSolutionConvertingRecipe>> MIDNIGHT_SOLUTION_CONVERTING;
    public static final RecipeType<RecipeHolder<DragonrotConvertingRecipe>> DRAGONROT_CONVERTING;
    public static final RecipeType<RecipeHolder<SpiritInstillerRecipe>> SPIRIT_INSTILLER;
    public static final RecipeType<RecipeHolder<InkConvertingRecipe>> INK_CONVERTING;
    public static final RecipeType<RecipeHolder<CrystallarieumRecipe>> CRYSTALLARIEUM;
    public static final RecipeType<RecipeHolder<CinderhearthRecipe>> CINDERHEARTH;
    public static final RecipeType<RecipeHolder<ITitrationBarrelRecipe>> TITRATION_BARREL;
    public static final RecipeType<RecipeHolder<PrimordialFireBurningRecipe>> PRIMORDIAL_FIRE_BURNING;
    public static final RecipeType<BlockConversionRecipe> NATURES_STAFF;
    public static final RecipeType<BlockConversionWithChanceRecipe> HEATING;
    public static final RecipeType<BlockConversionWithChanceRecipe> FREEZING;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (this.checkDisabled()) {
            return;
        }
        registration.registerSubtypeInterpreter((Item)PastelItems.KNOWLEDGE_GEM.get(), (ISubtypeInterpreter)new ExperienceStorageItemSubtypeInterpreter());
        registration.registerSubtypeInterpreter((Item)PastelItems.MIDNIGHT_ABERRATION.get(), (ISubtypeInterpreter)new UnstableItemSubtypeInterpreter());
        InkStorageItemSubtypeInterpreter ink = new InkStorageItemSubtypeInterpreter();
        registration.registerSubtypeInterpreter((Item)PastelItems.INK_FLASK.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.INK_ASSORTMENT.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.PIGMENT_PALETTE.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.ARTISTS_PALETTE.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.SHIELDGRASP_AMULET.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.HEARTSINGERS_REWARD.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.GLOVES_OF_DAWNS_GRASP.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.RING_OF_PURSUIT.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.RING_OF_DENSER_STEPS.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.RING_OF_AERIAL_GRACE.get(), (ISubtypeInterpreter)ink);
        registration.registerSubtypeInterpreter((Item)PastelItems.LAURELS_OF_SERENITY.get(), (ISubtypeInterpreter)ink);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        if (this.checkDisabled()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(PedestalTier.BASIC)});
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(PedestalTier.SIMPLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(PedestalTier.ADVANCED)});
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(PedestalTier.COMPLEX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AnvilCrushingRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionShrineRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnchantmentUpgradeRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new PotionWorkshopRecipeCategory<PotionWorkshopBrewingRecipe>(POTION_WORKSHOP_BREWING, (Component)Component.translatable((String)"container.pastel.rei.potion_workshop_brewing.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new PotionWorkshopRecipeCategory<PotionWorkshopCraftingRecipe>(POTION_WORKSHOP_CRAFTING, (Component)Component.translatable((String)"container.pastel.rei.potion_workshop_crafting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new DescriptiveGatedRecipeCategory<PotionWorkshopReactingRecipe>(POTION_WORKSHOP_REACTING, (Component)Component.translatable((String)"container.pastel.rei.potion_workshop_reacting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConvertingRecipeCategory<HumusConvertingRecipe>(HUMUS_CONVERTING, (Component)Component.translatable((String)"container.pastel.rei.humus_converting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConvertingRecipeCategory<LiquidCrystalConvertingRecipe>(LIQUID_CRYSTAL_CONVERTING, (Component)Component.translatable((String)"container.pastel.rei.liquid_crystal_converting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConvertingRecipeCategory<MidnightSolutionConvertingRecipe>(MIDNIGHT_SOLUTION_CONVERTING, (Component)Component.translatable((String)"container.pastel.rei.midnight_solution_converting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConvertingRecipeCategory<DragonrotConvertingRecipe>(DRAGONROT_CONVERTING, (Component)Component.translatable((String)"container.pastel.rei.dragonrot_converting.title"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpiritInstillerRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new InkConvertingRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystallarieumRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new CinderhearthRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new TitrationBarrelRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new PrimordialFireBurningRecipeCategory()});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionRecipeCategory(NATURES_STAFF, (Component)Component.translatable((String)"item.pastel.natures_staff"), PastelAdvancements.UNLOCK_NATURES_STAFF)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionWithChanceRecipeCategory(HEATING, (Component)Component.translatable((String)"container.pastel.rei.heating.title"), PastelAdvancements.UNLOCK_IDOLS)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionWithChanceRecipeCategory(FREEZING, (Component)Component.translatable((String)"container.pastel.rei.freezing.title"), PastelAdvancements.UNLOCK_IDOLS)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.checkDisabled()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(PEDESTAL_BASIC, recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL).stream().filter(r -> ((PedestalRecipe)r.value()).getTier() == PedestalTier.BASIC).toList());
        registration.addRecipes(PEDESTAL_SIMPLE, recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL).stream().filter(r -> ((PedestalRecipe)r.value()).getTier() == PedestalTier.SIMPLE).toList());
        registration.addRecipes(PEDESTAL_ADVANCED, recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL).stream().filter(r -> ((PedestalRecipe)r.value()).getTier() == PedestalTier.ADVANCED).toList());
        registration.addRecipes(PEDESTAL_COMPLEX, recipeManager.getAllRecipesFor(PastelRecipeTypes.PEDESTAL).stream().filter(r -> ((PedestalRecipe)r.value()).getTier() == PedestalTier.COMPLEX).toList());
        registration.addRecipes(ANVIL_CRUSHING, recipeManager.getAllRecipesFor(PastelRecipeTypes.ANVIL_CRUSHING));
        registration.addRecipes(FUSION_SHRINE, recipeManager.getAllRecipesFor(PastelRecipeTypes.FUSION_SHRINE));
        registration.addRecipes(ENCHANTER, recipeManager.getAllRecipesFor(PastelRecipeTypes.ENCHANTER));
        registration.addRecipes(ENCHANTMENT_UPGRADE, recipeManager.getAllRecipesFor(PastelRecipeTypes.ENCHANTMENT_UPGRADE));
        registration.addRecipes(POTION_WORKSHOP_BREWING, recipeManager.getAllRecipesFor(PastelRecipeTypes.POTION_WORKSHOP_BREWING));
        registration.addRecipes(POTION_WORKSHOP_CRAFTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.POTION_WORKSHOP_CRAFTING));
        registration.addRecipes(POTION_WORKSHOP_REACTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.POTION_WORKSHOP_REACTING));
        registration.addRecipes(HUMUS_CONVERTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.HUMUS_CONVERTING));
        registration.addRecipes(LIQUID_CRYSTAL_CONVERTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.LIQUID_CRYSTAL_CONVERTING));
        registration.addRecipes(MIDNIGHT_SOLUTION_CONVERTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING));
        registration.addRecipes(DRAGONROT_CONVERTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.DRAGONROT_CONVERTING));
        registration.addRecipes(SPIRIT_INSTILLER, recipeManager.getAllRecipesFor(PastelRecipeTypes.SPIRIT_INSTILLING));
        registration.addRecipes(INK_CONVERTING, recipeManager.getAllRecipesFor(PastelRecipeTypes.INK_CONVERTING));
        registration.addRecipes(CRYSTALLARIEUM, recipeManager.getAllRecipesFor(PastelRecipeTypes.CRYSTALLARIEUM));
        registration.addRecipes(CINDERHEARTH, recipeManager.getAllRecipesFor(PastelRecipeTypes.CINDERHEARTH));
        registration.addRecipes(TITRATION_BARREL, recipeManager.getAllRecipesFor(PastelRecipeTypes.TITRATION_BARREL));
        registration.addRecipes(PRIMORDIAL_FIRE_BURNING, recipeManager.getAllRecipesFor(PastelRecipeTypes.PRIMORDIAL_FIRE_BURNING));
        registration.addRecipes(NATURES_STAFF, NaturesStaffConversionDataLoader.CONVERSIONS.entrySet().stream().map(entry -> new BlockConversionRecipe((Block)entry.getKey(), (BlockState)entry.getValue())).filter(BlockConversionRecipe::isViewable).toList());
        registration.addRecipes(HEATING, FirestarterIdolBlock.BURNING_MAP.entrySet().stream().map(entry -> new BlockConversionWithChanceRecipe((Block)entry.getKey(), (BlockState)((Tuple)entry.getValue()).getA(), ((Float)((Tuple)entry.getValue()).getB()).floatValue())).filter(BlockConversionWithChanceRecipe::isViewable).toList());
        registration.addRecipes(FREEZING, Stream.concat(FreezingIdolBlock.FREEZING_STATE_MAP.entrySet().stream().map(entry -> new BlockConversionWithChanceRecipe((BlockState)entry.getKey(), (BlockState)((Tuple)entry.getValue()).getA(), ((Float)((Tuple)entry.getValue()).getB()).floatValue())), FreezingIdolBlock.FREEZING_MAP.entrySet().stream().map(entry -> new BlockConversionWithChanceRecipe((Block)entry.getKey(), (BlockState)((Tuple)entry.getValue()).getA(), ((Float)((Tuple)entry.getValue()).getB()).floatValue()))).filter(BlockConversionWithChanceRecipe::isViewable).toList());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (this.checkDisabled()) {
            return;
        }
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new PedestalRecipeTransferInfo(PedestalTier.BASIC));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new PedestalRecipeTransferInfo(PedestalTier.SIMPLE));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new PedestalRecipeTransferInfo(PedestalTier.ADVANCED));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new PedestalRecipeTransferInfo(PedestalTier.COMPLEX));
        registration.addRecipeTransferHandler(PedestalScreenHandler.class, PastelScreenHandlerTypes.PEDESTAL, RecipeTypes.CRAFTING, 0, 9, 16, 36);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTabletRecipeTransferHandler(PedestalTier.BASIC, transferHelper), PEDESTAL_BASIC);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTabletRecipeTransferHandler(PedestalTier.SIMPLE, transferHelper), PEDESTAL_SIMPLE);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTabletRecipeTransferHandler(PedestalTier.ADVANCED, transferHelper), PEDESTAL_ADVANCED);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTabletRecipeTransferHandler(PedestalTier.COMPLEX, transferHelper), PEDESTAL_COMPLEX);
        registration.addRecipeTransferHandler(CraftingTabletScreenHandler.class, PastelScreenHandlerTypes.CRAFTING_TABLET, RecipeTypes.CRAFTING, 0, 9, 15, 36);
        registration.addRecipeTransferHandler(new GatedRecipeTransferInfo<PotionWorkshopScreenHandler, PotionWorkshopBrewingRecipe>(PotionWorkshopScreenHandler.class, PastelScreenHandlerTypes.POTION_WORKSHOP, POTION_WORKSHOP_BREWING, 0, 9, 21, 36));
        registration.addRecipeTransferHandler(new GatedRecipeTransferInfo<PotionWorkshopScreenHandler, PotionWorkshopCraftingRecipe>(PotionWorkshopScreenHandler.class, PastelScreenHandlerTypes.POTION_WORKSHOP, POTION_WORKSHOP_CRAFTING, 0, 9, 21, 36));
        registration.addRecipeTransferHandler(new GatedRecipeTransferInfo<CinderhearthScreenHandler, CinderhearthRecipe>(CinderhearthScreenHandler.class, PastelScreenHandlerTypes.CINDERHEARTH, CINDERHEARTH, 2, 1, 11, 36));
        registration.addRecipeTransferHandler(CinderhearthScreenHandler.class, PastelScreenHandlerTypes.CINDERHEARTH, RecipeTypes.BLASTING, 2, 1, 11, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.FABRICATION_CHEST, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_TOPAZ, new RecipeType[]{PEDESTAL_BASIC});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_AMETHYST, new RecipeType[]{PEDESTAL_BASIC});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_CITRINE, new RecipeType[]{PEDESTAL_BASIC});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_ALL_BASIC, new RecipeType[]{PEDESTAL_BASIC, PEDESTAL_SIMPLE});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_ONYX, new RecipeType[]{PEDESTAL_BASIC, PEDESTAL_SIMPLE, PEDESTAL_ADVANCED});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_MOONSTONE, new RecipeType[]{PEDESTAL_BASIC, PEDESTAL_SIMPLE, PEDESTAL_ADVANCED, PEDESTAL_COMPLEX});
        if (PastelCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_TOPAZ, new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_AMETHYST, new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_BASIC_CITRINE, new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_ALL_BASIC, new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_ONYX, new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst((ItemLike)PastelBlocks.PEDESTAL_MOONSTONE, new RecipeType[]{RecipeTypes.CRAFTING});
        }
        registration.addRecipeCatalyst((ItemLike)PastelItems.CRAFTING_TABLET, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst((ItemLike)Blocks.ANVIL, new RecipeType[]{ANVIL_CRUSHING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.BEDROCK_ANVIL, new RecipeType[]{ANVIL_CRUSHING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.STRATINE_FLOATBLOCK, new RecipeType[]{ANVIL_CRUSHING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.PALTAERIA_FLOATBLOCK, new RecipeType[]{ANVIL_CRUSHING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT, new RecipeType[]{FUSION_SHRINE});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.FUSION_SHRINE_CALCITE, new RecipeType[]{FUSION_SHRINE});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.ENCHANTER, new RecipeType[]{ENCHANTER, ENCHANTMENT_UPGRADE});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.POTION_WORKSHOP, new RecipeType[]{POTION_WORKSHOP_BREWING, POTION_WORKSHOP_CRAFTING, POTION_WORKSHOP_REACTING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.HUMUS_BUCKET, new RecipeType[]{HUMUS_CONVERTING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.LIQUID_CRYSTAL_BUCKET, new RecipeType[]{LIQUID_CRYSTAL_CONVERTING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.MIDNIGHT_SOLUTION_BUCKET, new RecipeType[]{MIDNIGHT_SOLUTION_CONVERTING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.DRAGONROT_BUCKET, new RecipeType[]{DRAGONROT_CONVERTING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.SPIRIT_INSTILLER, new RecipeType[]{SPIRIT_INSTILLER});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.COLOR_PICKER, new RecipeType[]{INK_CONVERTING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.CRYSTALLARIEUM, new RecipeType[]{CRYSTALLARIEUM});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.CINDERHEARTH, new RecipeType[]{CINDERHEARTH, RecipeTypes.BLASTING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.TITRATION_BARREL, new RecipeType[]{TITRATION_BARREL});
        registration.addRecipeCatalyst((ItemLike)PastelItems.DOOMBLOOM_SEED, new RecipeType[]{PRIMORDIAL_FIRE_BURNING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.PRIMORDIAL_LIGHTER, new RecipeType[]{PRIMORDIAL_FIRE_BURNING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.INCANDESCENT_AMALGAM, new RecipeType[]{PRIMORDIAL_FIRE_BURNING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.PIPE_BOMB, new RecipeType[]{PRIMORDIAL_FIRE_BURNING});
        registration.addRecipeCatalyst((ItemLike)PastelItems.NATURES_STAFF, new RecipeType[]{NATURES_STAFF});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.BLAZE_IDOL, new RecipeType[]{HEATING});
        registration.addRecipeCatalyst((ItemLike)PastelBlocks.POLAR_BEAR_IDOL, new RecipeType[]{FREEZING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (this.checkDisabled()) {
            return;
        }
        registration.addGuiContainerHandler(PedestalScreen.class, (IGuiContainerHandler)new PedestalRecipeClickAreaHandler());
        registration.addGuiContainerHandler(CraftingTabletScreen.class, (IGuiContainerHandler)new CraftingTabletRecipeClickAreaHandler());
        registration.addRecipeClickArea(PotionWorkshopScreen.class, 28, 41, 12, 42, new RecipeType[]{POTION_WORKSHOP_BREWING, POTION_WORKSHOP_CRAFTING, POTION_WORKSHOP_REACTING});
        registration.addRecipeClickArea(CinderhearthScreen.class, 35, 31, 22, 16, new RecipeType[]{CINDERHEARTH, RecipeTypes.BLASTING});
        registration.addGuiContainerHandler(QuickNavigationGridScreen.class, new OverlayHidingExtraAreaHandler());
        registration.addGhostIngredientHandler(BlackHoleChestScreen.class, new ShadowSlotGhostIngredientHandler());
        registration.addGhostIngredientHandler(FilteringScreen.class, new ShadowSlotGhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PastelJEI.jeiRuntime = jeiRuntime;
    }

    public boolean checkDisabled() {
        if (ModList.get().isLoaded("rei_plugin_compatibilities")) {
            LOGGER.warn("PastelJEI is disabled with REIPC as Pastel has native REI support");
            return true;
        }
        if (ModList.get().isLoaded("emi")) {
            LOGGER.warn("PastelJEI is disabled with EMI as Pastel has native EMI support");
            return true;
        }
        return false;
    }

    static {
        PEDESTAL_BASIC = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"pedestal_basic"));
        PEDESTAL_SIMPLE = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"pedestal_simple"));
        PEDESTAL_ADVANCED = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"pedestal_advanced"));
        PEDESTAL_COMPLEX = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"pedestal_complex"));
        ANVIL_CRUSHING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"anvil_crushing"));
        FUSION_SHRINE = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"fusion_shrine"));
        ENCHANTER = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"enchanter"));
        ENCHANTMENT_UPGRADE = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"enchantment_upgrade"));
        POTION_WORKSHOP_BREWING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"potion_workshop_brewing"));
        POTION_WORKSHOP_CRAFTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"potion_workshop_crafting"));
        POTION_WORKSHOP_REACTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"potion_workshop_reacting"));
        HUMUS_CONVERTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"humus_converting"));
        LIQUID_CRYSTAL_CONVERTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"liquid_crystal_converting"));
        MIDNIGHT_SOLUTION_CONVERTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"midnight_solution_converting"));
        DRAGONROT_CONVERTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"dragonrot_converting"));
        SPIRIT_INSTILLER = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"spirit_instiller"));
        INK_CONVERTING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"ink_converting"));
        CRYSTALLARIEUM = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"crystallarieum"));
        CINDERHEARTH = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"cinderhearth"));
        TITRATION_BARREL = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"titration_barrel"));
        PRIMORDIAL_FIRE_BURNING = RecipeType.createRecipeHolderType((ResourceLocation)PastelCommon.locate((String)"primordial_fire_burning"));
        NATURES_STAFF = new RecipeType(PastelCommon.locate((String)"natures_staff"), BlockConversionRecipe.class);
        HEATING = new RecipeType(PastelCommon.locate((String)"heating"), BlockConversionWithChanceRecipe.class);
        FREEZING = new RecipeType(PastelCommon.locate((String)"freezing"), BlockConversionWithChanceRecipe.class);
    }
}

