/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.client;

import codechicken.lib.vec.Cuboid6;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.tile.IllumarLampBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class IllumarLampBlockEntityRenderer
implements BlockEntityRenderer<IllumarLampBlockEntity> {
    public static final IllumarLampBlockEntityRenderer INSTANCE = new IllumarLampBlockEntityRenderer();
    public static final Cuboid6 GLOW_BOUNDS = Cuboid6.full.copy().expand(0.05);

    private IllumarLampBlockEntityRenderer() {
    }

    public void render(IllumarLampBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        BlockState state;
        if (tile.getLevel() != null && (state = tile.getLevel().getBlockState(tile.getBlockPos())).getBlock() instanceof IllumarLampBlock && tile.isLit()) {
            HaloRenderer.addLight((BlockPos)tile.getBlockPos(), (Cuboid6)GLOW_BOUNDS, (int)tile.color);
        }
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(IllumarLampBlockEntity blockEntity) {
        return GLOW_BOUNDS.copy().add(blockEntity.getBlockPos()).aabb();
    }
}

