/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.block;

import codechicken.multipart.api.RedstoneConnectorBlock;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.tile.IllumarLampBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class IllumarLampBlock
extends Block
implements EntityBlock,
RedstoneConnectorBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    private final int color;
    private final boolean inverted;

    public IllumarLampBlock(int color, boolean inverted) {
        super(BlockBehaviour.Properties.of().mapColor(state -> (Boolean)state.getValue((Property)LIT) != false ? MapColor.byId((int)(MapColor.TERRACOTTA_WHITE.id + color)) : MapColor.COLOR_GRAY).sound(SoundType.GLASS).strength(0.5f).lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 15 : 0));
        this.color = color;
        this.inverted = inverted;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(inverted)));
    }

    public int getColor() {
        return this.color;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos()) != this.inverted));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        boolean shouldBeLit;
        super.onNeighborChange(state, (LevelReader)world, pos, neighbor);
        if (world.isClientSide()) {
            return;
        }
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        boolean bl = shouldBeLit = world.hasNeighborSignal(pos) != this.inverted;
        if (isLit != shouldBeLit && !world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            world.scheduleTick(pos, (Block)this, 2);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        boolean shouldBeLit;
        super.tick(state, world, pos, rand);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        boolean bl = shouldBeLit = world.hasNeighborSignal(pos) != this.inverted;
        if (isLit != shouldBeLit) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new IllumarLampBlockEntity(this.color, this.inverted, pos, state);
    }

    public int getConnectionMask(LevelReader world, BlockPos pos, int side) {
        return 31;
    }

    public int weakPowerLevel(LevelReader world, BlockPos pos, int side, int mask) {
        return 0;
    }
}

