/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.SimpleMultipartType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.item.MultipartLightPartItem;
import mrtjp.projectred.illumination.part.CageLightProperties;
import mrtjp.projectred.illumination.part.FalloutLightProperties;
import mrtjp.projectred.illumination.part.FixtureLightProperties;
import mrtjp.projectred.illumination.part.LanternLightProperties;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum MultipartLightType {
    FIXTURE("fixture_light", "Fixture Light", new FixtureLightProperties()),
    FALLOUT("fallout_light", "Fallout Light", new FalloutLightProperties()),
    CAGE("cage_light", "Cage Light", new CageLightProperties()),
    LANTERN("lantern", "Lantern", new LanternLightProperties());

    private final String unlocalName;
    private final String localName;
    private final MultipartLightProperties properties;
    private final List<Supplier<Item>> itemSuppliers = new ArrayList<Supplier<Item>>();
    private final List<Supplier<Item>> invertedItemSuppliers = new ArrayList<Supplier<Item>>();
    private final List<Supplier<MultipartType<MultipartLightPart>>> partSuppliers = new ArrayList<Supplier<MultipartType<MultipartLightPart>>>();
    private final List<Supplier<MultipartType<MultipartLightPart>>> invertedPartSuppliers = new ArrayList<Supplier<MultipartType<MultipartLightPart>>>();

    private MultipartLightType(String unlocalName, String localName, MultipartLightProperties properties) {
        this.unlocalName = unlocalName;
        this.localName = localName;
        this.properties = properties;
    }

    public MultipartLightProperties getProperties() {
        return this.properties;
    }

    public void registerParts(DeferredRegister<MultipartType<?>> partRegistry, DeferredRegister<Item> itemRegistry) {
        int colorFinal;
        int color;
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String regID = MultipartLightType.getRegistryID(this.unlocalName, color, false);
            this.itemSuppliers.add(color, (Supplier<Item>)itemRegistry.register(regID, () -> new MultipartLightPartItem(this.properties, colorFinal, false)));
            this.partSuppliers.add(color, (Supplier<MultipartType<MultipartLightPart>>)partRegistry.register(regID, () -> new SimpleMultipartType(isClient -> this.properties.partFactory(colorFinal, false))));
        }
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String invRegID = MultipartLightType.getRegistryID(this.unlocalName, color, true);
            this.invertedItemSuppliers.add(color, (Supplier<Item>)itemRegistry.register(invRegID, () -> new MultipartLightPartItem(this.properties, colorFinal, true)));
            this.invertedPartSuppliers.add(color, (Supplier<MultipartType<MultipartLightPart>>)partRegistry.register(invRegID, () -> new SimpleMultipartType(isClient -> this.properties.partFactory(colorFinal, true))));
        }
    }

    public Supplier<Item> getItemRegistryObject(int color, boolean inverted) {
        return inverted ? this.invertedItemSuppliers.get(color) : this.itemSuppliers.get(color);
    }

    public Item getItem(int color, boolean inverted) {
        return inverted ? this.invertedItemSuppliers.get(color).get() : this.itemSuppliers.get(color).get();
    }

    public Iterable<Item> getAllItems(boolean inverted) {
        return FastStream.of(inverted ? this.invertedItemSuppliers : this.itemSuppliers).map(Supplier::get);
    }

    public ItemStack makeStack(int colour, boolean inverted) {
        Item item = (inverted ? this.invertedItemSuppliers : this.itemSuppliers).get(colour).get();
        return new ItemStack((ItemLike)item);
    }

    public MultipartType<MultipartLightPart> getPartType(int color, boolean inverted) {
        return inverted ? this.invertedPartSuppliers.get(color).get() : this.partSuppliers.get(color).get();
    }

    public String getLocalBaseName() {
        return this.localName;
    }

    public String getUnlocalBaseName() {
        return this.unlocalName;
    }

    public String getRegistryID(int color, boolean inverted) {
        return MultipartLightType.getRegistryID(this.unlocalName, color, inverted);
    }

    private static String getRegistryID(String name, int color, boolean inverted) {
        return EnumColour.values()[color].getSerializedName() + (inverted ? "_inverted" : "") + "_" + name;
    }
}

