/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.typewriter;

import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterBlock;
import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterPage;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCBlockEntity;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class TypewriterBlockEntity
extends BCBlockEntity
implements WorldlyContainer {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private static final int[] INPUTS = new int[]{0};
    private static final int[] OUTPUTS = new int[]{1};
    private static final String PAGE_KEY = "page";
    private final EnumMap<Direction, SidedInvWrapper> wrappers = (EnumMap)Util.make(new EnumMap(Direction.class), map -> {
        for (Direction direction : Direction.values()) {
            map.put(direction, new SidedInvWrapper((WorldlyContainer)this, direction));
        }
    });
    private TypewriterPage page = new TypewriterPage();

    public TypewriterBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.TYPEWRITER.get(), 2, pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.page = CodecUtil.decodeNbt(TypewriterPage.CODEC, (Tag)tag.getCompound(PAGE_KEY));
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(PAGE_KEY, CodecUtil.encodeNbt(TypewriterPage.CODEC, this.page));
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && stack.is(BCTags.Items.TYPEWRITER_PAPER);
    }

    @Override
    public IItemHandler getCapability(@Nullable Direction side) {
        return side == null ? null : (IItemHandler)this.wrappers.get(side);
    }

    public int[] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? OUTPUTS : INPUTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return direction != Direction.DOWN && this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && index == 1;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        if (slot == 1 && this.getItem(1).isEmpty()) {
            this.setPage(TypewriterPage.DEFAULT);
            this.setChanged();
        }
    }

    @Override
    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = super.removeItem(slot, count);
        if (slot == 1 && this.getItem(1).isEmpty()) {
            this.setPage(TypewriterPage.DEFAULT);
            this.setChanged();
        }
        return stack;
    }

    public boolean insertPaper(ItemStack stack) {
        ItemStack input = this.getItem(0);
        if (!input.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)stack)) {
            return false;
        }
        if (input.isEmpty()) {
            this.setItem(0, stack.copyWithCount(1));
        } else if (input.getCount() < input.getMaxStackSize()) {
            input.grow(1);
        } else {
            return false;
        }
        stack.shrink(1);
        this.setChanged();
        return true;
    }

    public ItemStack takeOutput() {
        ItemStack output = this.getItem(1);
        this.setItem(1, ItemStack.EMPTY);
        this.level().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)TypewriterBlock.PAPER, (Comparable)Integer.valueOf(0)));
        this.setChanged();
        return output;
    }

    public TypewriterPage getPage() {
        return this.page;
    }

    public void setPage(TypewriterPage page) {
        this.page = page;
        if (page.line() == 14) {
            ItemStack output = new ItemStack((ItemLike)BCItems.TYPEWRITER_PAGE.get());
            output.set(BCDataComponents.TYPEWRITER_PAGE, (Object)page);
            this.setItem(1, output);
            this.getItem(0).shrink(1);
            this.page = TypewriterPage.DEFAULT;
        }
        BlockState state = (BlockState)this.getBlockState().setValue((Property)TypewriterBlock.PAPER, (Comparable)Integer.valueOf(page.line() / 2));
        if (this.getBlockState() != state) {
            this.level().setBlockAndUpdate(this.getBlockPos(), state);
        }
        this.setChanged();
    }
}

