/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog;

import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogItem;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogItemEntry;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogListPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogSorting;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.LecternUtil;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StockroomCatalogRequestListPacket(StockroomCatalogSorting.Container containerSorting, StockroomCatalogSorting.Item itemSorting, Either<InteractionHand, BlockPos> target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StockroomCatalogRequestListPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("stockroom_catalog_request_list"));
    public static final StreamCodec<ByteBuf, StockroomCatalogRequestListPacket> STREAM_CODEC = StreamCodec.composite(StockroomCatalogSorting.Container.STREAM_CODEC, StockroomCatalogRequestListPacket::containerSorting, StockroomCatalogSorting.Item.STREAM_CODEC, StockroomCatalogRequestListPacket::itemSorting, (StreamCodec)ByteBufCodecs.either(CodecUtil.INTERACTION_HAND_STREAM_CODEC, (StreamCodec)BlockPos.STREAM_CODEC), StockroomCatalogRequestListPacket::target, StockroomCatalogRequestListPacket::new);

    public void handle(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = (ItemStack)this.target.map(arg_0 -> ((Player)player).getItemInHand(arg_0), pos -> LecternUtil.tryGetLecternAndApply(player.level(), pos, LecternBlockEntity::getBook));
        List<BlockPos> containers = StockroomCatalogItem.calculatePositions(stack, player.level(), player, this.containerSorting);
        List<StockroomCatalogItemEntry> items = StockroomCatalogItem.calculateItems(containers, player.level(), this.itemSorting);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StockroomCatalogListPacket(containers, items), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

