/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.seat;

import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackItem;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackType;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBlock;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCFacingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatBackBlock
extends BCFacingBlock {
    public static final EnumProperty<SeatBackType> TYPE = EnumProperty.create((String)"type", SeatBackType.class);
    private static final VoxelShape SHAPE_SMALL_NORTH = Shapes.box((double)0.125, (double)0.0, (double)0.8125, (double)0.875, (double)0.296875, (double)0.9375);
    private static final VoxelShape SHAPE_SMALL_EAST = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_SMALL_SOUTH = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_SMALL_WEST = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_RAISED_NORTH = ShapeUtil.combine(Shapes.box((double)0.1875, (double)0.0, (double)0.75, (double)0.3125, (double)0.5, (double)0.96875), Shapes.box((double)0.6875, (double)0.0, (double)0.75, (double)0.8125, (double)0.5, (double)0.96875), Shapes.box((double)0.125, (double)0.25, (double)0.71875, (double)0.875, (double)0.625, (double)0.84375));
    private static final VoxelShape SHAPE_RAISED_EAST = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_RAISED_SOUTH = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_RAISED_WEST = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_FLAT_NORTH = Shapes.box((double)0.125, (double)0.0, (double)0.8125, (double)0.875, (double)0.625, (double)0.9375);
    private static final VoxelShape SHAPE_FLAT_EAST = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_FLAT_SOUTH = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_FLAT_WEST = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_TALL_NORTH = ShapeUtil.combine(Shapes.box((double)0.125, (double)0.0, (double)0.8125, (double)0.875, (double)0.6875, (double)0.9375), Shapes.box((double)0.625, (double)0.6875, (double)0.8125, (double)0.6875, (double)0.8125, (double)0.9375), Shapes.box((double)0.3125, (double)0.6875, (double)0.8125, (double)0.375, (double)0.8125, (double)0.9375), Shapes.box((double)0.3125, (double)0.8125, (double)0.8125, (double)0.6875, (double)0.875, (double)0.9375));
    private static final VoxelShape SHAPE_TALL_EAST = ShapeUtil.rotate(SHAPE_TALL_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_TALL_SOUTH = ShapeUtil.rotate(SHAPE_TALL_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_TALL_WEST = ShapeUtil.rotate(SHAPE_TALL_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_FANCY_NORTH = ShapeUtil.combine(Shapes.box((double)0.125, (double)0.0, (double)0.8125, (double)0.875, (double)0.8125, (double)0.9375), Shapes.box((double)0.25, (double)0.8125, (double)0.8125, (double)0.75, (double)0.84375, (double)0.9375), Shapes.box((double)0.375, (double)0.84375, (double)0.8125, (double)0.625, (double)0.875, (double)0.9375), Shapes.box((double)0.875, (double)0.0, (double)0.0625, (double)1.0, (double)0.03125, (double)0.4375), Shapes.box((double)0.875, (double)0.03125, (double)0.1875, (double)1.0, (double)0.0625, (double)0.3125), Shapes.box((double)0.875, (double)0.0, (double)0.6875, (double)1.0, (double)0.0625, (double)0.75), Shapes.box((double)0.875, (double)0.0, (double)0.75, (double)1.0, (double)0.8125, (double)0.9375), Shapes.box((double)0.875, (double)0.375, (double)0.71875, (double)1.0, (double)0.75, (double)0.75), Shapes.box((double)0.875, (double)0.5, (double)0.6875, (double)1.0, (double)0.625, (double)0.71875), Shapes.box((double)0.0, (double)0.0, (double)0.0625, (double)0.125, (double)0.03125, (double)0.4375), Shapes.box((double)0.0, (double)0.03125, (double)0.1875, (double)0.125, (double)0.0625, (double)0.3125), Shapes.box((double)0.0, (double)0.0, (double)0.6875, (double)0.125, (double)0.0625, (double)0.75), Shapes.box((double)0.0, (double)0.0, (double)0.75, (double)0.125, (double)0.8125, (double)0.9375), Shapes.box((double)0.0, (double)0.375, (double)0.71875, (double)0.125, (double)0.75, (double)0.75), Shapes.box((double)0.0, (double)0.5, (double)0.6875, (double)0.125, (double)0.625, (double)0.71875));
    private static final VoxelShape SHAPE_FANCY_EAST = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_FANCY_SOUTH = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_FANCY_WEST = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.COUNTERCLOCKWISE_90);

    public SeatBackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)SeatBackType.SMALL)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).getBlock() instanceof SeatBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((SeatBackType)((Object)state.getValue(TYPE))) {
            default -> throw new MatchException(null, null);
            case SeatBackType.SMALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield SHAPE_SMALL_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_SMALL_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_SMALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_SMALL_WEST;
                    }
                }
                yield Shapes.empty();
            }
            case SeatBackType.RAISED -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield SHAPE_RAISED_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_RAISED_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_RAISED_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_RAISED_WEST;
                    }
                }
                yield Shapes.empty();
            }
            case SeatBackType.FLAT -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield SHAPE_FLAT_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_FLAT_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_FLAT_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_FLAT_WEST;
                    }
                }
                yield Shapes.empty();
            }
            case SeatBackType.TALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield SHAPE_TALL_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_TALL_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_TALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_TALL_WEST;
                    }
                }
                yield Shapes.empty();
            }
            case SeatBackType.FANCY -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield SHAPE_FANCY_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_FANCY_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_FANCY_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_FANCY_WEST;
                    }
                }
                yield Shapes.empty();
            }
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)SeatBackItem.BLOCK_MAP.get((Object)this).get(state.getValue(TYPE)).get());
    }
}

