/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PrintingTableTankSyncPacket(BlockPos pos, Fluid fluid, int amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PrintingTableTankSyncPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("printing_table_tank_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintingTableTankSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PrintingTableTankSyncPacket::pos, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), PrintingTableTankSyncPacket::fluid, (StreamCodec)ByteBufCodecs.INT, PrintingTableTankSyncPacket::amount, PrintingTableTankSyncPacket::new);

    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(this.pos);
        if (blockEntity instanceof PrintingTableBlockEntity) {
            PrintingTableBlockEntity printingTable = (PrintingTableBlockEntity)blockEntity;
            printingTable.getFluidCapability().update(this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

