/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.bookcase;

import com.github.minecraftschurlimods.bibliocraft.content.bookcase.BookcaseBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.redstonebook.RedstoneBookItem;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCFacingEntityBlock;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BookcaseBlock
extends BCFacingEntityBlock {
    private static final VoxelShape NORTH_SHAPE = ShapeUtil.combine(Shapes.box((double)0.0625, (double)0.0, (double)0.5, (double)0.9375, (double)0.0625, (double)0.9375), Shapes.box((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0625, (double)0.9375, (double)0.5, (double)0.9375, (double)1.0, (double)0.9375), Shapes.box((double)0.0625, (double)0.4375, (double)0.5, (double)0.9375, (double)0.5625, (double)0.9375), Shapes.box((double)0.9375, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)0.9375), Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)0.0625, (double)1.0, (double)0.9375));
    private static final VoxelShape EAST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public BookcaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BookcaseBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return super.getAnalogOutputSignal(state, level, pos);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BookcaseBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, pos);
        }
        BookcaseBlockEntity bcbe = (BookcaseBlockEntity)blockEntity;
        for (int i = 15; i >= 0; --i) {
            if (!(bcbe.getItem(i).getItem() instanceof RedstoneBookItem)) continue;
            return i;
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BookcaseBlockEntity)) {
            return super.getEnchantPowerBonus(state, level, pos);
        }
        BookcaseBlockEntity bcbe = (BookcaseBlockEntity)blockEntity;
        return super.getEnchantPowerBonus(state, level, pos) + 0.125f * (float)IntStream.range(0, bcbe.getContainerSize()).mapToObj(bcbe::getItem).filter(e -> !e.isEmpty()).count();
    }
}

