/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.bigbook;

import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookContent;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.WrittenBigBookContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BigBookItem
extends Item {
    public BigBookItem(boolean isWritten) {
        super(isWritten ? new Item.Properties().component(DataComponents.MAX_STACK_SIZE, (Object)1).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true).component(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT, (Object)WrittenBigBookContent.DEFAULT) : new Item.Properties().component(DataComponents.MAX_STACK_SIZE, (Object)1).component(BCDataComponents.BIG_BOOK_CONTENT, (Object)BigBookContent.DEFAULT));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            ClientUtil.openBigBookScreen(stack, player, hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public Component getName(ItemStack stack) {
        String title;
        WrittenBigBookContent content = (WrittenBigBookContent)stack.get(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT);
        if (content != null && !StringUtil.isBlank((String)(title = content.title()))) {
            return Component.literal((String)title);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        WrittenBigBookContent content = (WrittenBigBookContent)stack.get(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT);
        if (content != null) {
            String author = content.author();
            if (!StringUtil.isBlank((String)author)) {
                tooltipComponents.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{author}).withStyle(ChatFormatting.GRAY));
            }
            tooltipComponents.add((Component)Component.translatable((String)("book.generation." + content.generation())).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

