/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.ber;

import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlock;
import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class TableBER
implements BlockEntityRenderer<TableBlockEntity> {
    private static final RenderType MAP_BACKGROUND = RenderType.text((ResourceLocation)BCUtil.mcLoc("textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderType.text((ResourceLocation)BCUtil.mcLoc("textures/map/map_background_checkerboard.png"));
    private static final Map<TableBlock.Type, Map<DyeColor, BakedModel>> CLOTH_MAP = new HashMap<TableBlock.Type, Map<DyeColor, BakedModel>>();
    private static final RandomSource RANDOM = RandomSource.create();

    public static void rebuildClothModelCache() {
        CLOTH_MAP.clear();
        ModelManager models = ClientUtil.getMc().getModelManager();
        for (TableBlock.Type type : TableBlock.Type.values()) {
            HashMap<DyeColor, BakedModel> map = new HashMap<DyeColor, BakedModel>();
            for (DyeColor color : DyeColor.values()) {
                map.put(color, models.getModel(ModelResourceLocation.standalone((ResourceLocation)BCUtil.bcLoc("block/color/" + color.getSerializedName() + "/table_cloth_" + type.getSerializedName()))));
            }
            CLOTH_MAP.put(type, map);
        }
    }

    public void render(TableBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        BlockItem bi;
        VertexConsumer vc;
        ItemStack item = blockEntity.getItem(0);
        stack.pushPose();
        if (item.is(Items.FILLED_MAP)) {
            stack.translate(0.125, 1.001, 0.125);
            stack.scale(0.75f, 0.75f, 0.75f);
            stack.scale(0.0078125f, 0.0078125f, 0.0078125f);
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            Minecraft minecraft = ClientUtil.getMc();
            MapId mapId = (MapId)item.get(DataComponents.MAP_ID);
            MapItemSavedData mapData = MapItem.getSavedData((MapId)mapId, (Level)ClientUtil.getLevel());
            vc = buffer.getBuffer(mapData == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD);
            Matrix4f matrix4f = stack.last().pose();
            vc.addVertex(matrix4f, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(light);
            vc.addVertex(matrix4f, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(light);
            vc.addVertex(matrix4f, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(light);
            vc.addVertex(matrix4f, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(light);
            if (mapData != null) {
                minecraft.gameRenderer.getMapRenderer().render(stack, buffer, mapId, mapData, false, light);
            }
        } else {
            stack.translate(0.5, 1.03125, 0.5);
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            stack.scale(0.5f, 0.5f, 0.5f);
            ClientUtil.renderFixedItem(item, stack, buffer, light, overlay);
        }
        stack.popPose();
        ItemStack carpet = blockEntity.getItem(1);
        if (carpet.isEmpty() || !((vc = carpet.getItem()) instanceof BlockItem) || !((vc = (bi = (BlockItem)vc).getBlock()) instanceof WoolCarpetBlock)) {
            return;
        }
        WoolCarpetBlock carpetBlock = (WoolCarpetBlock)vc;
        BlockState state = blockEntity.getBlockState();
        stack.pushPose();
        stack.translate(0.5, 0.0, 0.5);
        stack.mulPose(Axis.YP.rotationDegrees(switch ((Direction)state.getValue((Property)TableBlock.FACING)) {
            case Direction.SOUTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
            case Direction.WEST -> 90.0f;
        }));
        stack.translate(-0.5, 0.0, -0.5);
        ClientUtil.renderBakedModel(CLOTH_MAP.get(state.getValue(TableBlock.TYPE)).get(carpetBlock.getColor()), stack, buffer, blockEntity.getLevel(), blockEntity.getBlockPos(), state, RANDOM, ModelData.EMPTY);
        stack.popPose();
    }
}

