/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.worldgen;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.worldgen.NMLPlacedFeatures;
import com.farcr.nomansland.datagen.worldgen.BiomeModifierBuilder;
import com.farcr.nomansland.datagen.worldgen.FeatureWithStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NMLBiomeModifiers {
    private final BootstrapContext<BiomeModifier> bootstrap;
    private final Map<FeatureWithStep, List<Holder<Biome>>> featureToBiomes = new HashMap<FeatureWithStep, List<Holder<Biome>>>();

    public NMLBiomeModifiers(BootstrapContext<BiomeModifier> bootstrap) {
        this.bootstrap = bootstrap;
        this.setup();
    }

    private void setup() {
        GenerationStep.Decoration vegetalDecoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        GenerationStep.Decoration localModifications = GenerationStep.Decoration.LOCAL_MODIFICATIONS;
        this.modifyBiome((ResourceKey<Biome>)Biomes.BADLANDS).changeColors(15322281, 4106959, 3048361, 11128544).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4)).removeSpawns(EntityType.ZOMBIE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE).changeColors(11071699, 2403207, 1479552, 7194319, 6798649, 6203171).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_JUNGLE, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowerBed("jungle"), NMLPlacedFeatures.patch("hearty_succulent"))).removeFeatures(VegetationPlacements.PATCH_PUMPKIN).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 8, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.PANDA, 80, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 16, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 6, 4, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 2, 8)).removeSpawns(EntityType.SHEEP).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.BEACH).changeColors(12906239, 3902136, 2388383, 7715315, 9680231, 8960833).removeFeatures(VegetationPlacements.PATCH_GRASS_BADLANDS, VegetationPlacements.FLOWER_DEFAULT).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.BIRCH_FOREST).changeColors(12906239, 3902136, 2388383, 7715315, 8367967, 6594108).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowerBed("white"), NMLPlacedFeatures.flowers("birch_forest"), NMLPlacedFeatures.patch("peony_and_lilac"))).removeFeatures(VegetationPlacements.FOREST_FLOWERS).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 4, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.COW, 2, 4, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 3, 4)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.CHERRY_GROVE).changeColors(0xEFEEFF, 3895992, 2388383, 8307162, 9620606, 9098883).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.trees("cherry_grove"), NMLPlacedFeatures.flowerBed("white_and_violet"), NMLPlacedFeatures.flowers("cherry"), VegetationPlacements.PATCH_SUGAR_CANE, VegetationPlacements.BROWN_MUSHROOM_NORMAL, VegetationPlacements.PATCH_WATERLILY)).removeFeatures(VegetationPlacements.TREES_CHERRY).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 1, 8), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 2, 6), new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 8, 2, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 4, 2, 6)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.COLD_OCEAN).changeColors(12639487, 3899064, 2386591, 8431871, 9680231, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN, VegetationPlacements.PATCH_SUGAR_CANE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DARK_FOREST).changeColors(12906239, 3902136, 2388383, 7715315, 6387766, 6523436).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("maple"), NMLPlacedFeatures.flowerBed("red"), NMLPlacedFeatures.patch("rose_bush"), NMLPlacedFeatures.feature("shelf_mushroom_dark_forest"), VegetationPlacements.BROWN_MUSHROOM_OLD_GROWTH)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.FOREST_FLOWERS, VegetationPlacements.BROWN_MUSHROOM_NORMAL).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 3, 4), new MobSpawnSettings.SpawnerData(EntityType.WOLF, 7, 2, 6)).removeSpawns(EntityType.SHEEP, EntityType.COW).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN).changeColors(12639487, 3899064, 2386591, 8431871, 9680231, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN, VegetationPlacements.PATCH_SUGAR_CANE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DEEP_DARK).changeColors(745045, 0x144151, 662565, 745045, 8622426, 7631435).changeParticle((ParticleOptions)NMLParticleTypes.SCULK_AMBIENCE.get(), 0.005f).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN).changeColors(15200511, 4223408, 2383519, 8431871, 10205860, 9680231).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN, VegetationPlacements.PATCH_SUGAR_CANE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DEEP_LUKEWARM_OCEAN).changeColors(12711423, 3906239, 2979747, 6800872, 9419352, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DEEP_OCEAN).changeColors(12906239, 3902136, 2388383, 7715315, 9680231, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DESERT).changeColors(15527891, 4106959, 3048361, 12113081, 14663027, 12762457).removeFeatures(VegetationPlacements.PATCH_SUGAR_CANE_DESERT).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 5, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 20, 2, 8)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.CAMEL, 20, 2, 8)).removeSpawns(EntityType.ZOMBIE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES).changeColors(4210492, 6913929, 3820113, 7907327, 8622426, 7631435).changeParticle((ParticleOptions)NMLParticleTypes.CAVE_DUST.get(), 0.01f).addFeatures(new FeatureWithStep(NMLPlacedFeatures.feature("underground/ore_silt"), GenerationStep.Decoration.UNDERGROUND_ORES)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.ERODED_BADLANDS).changeColors(15322281, 4106959, 3048361, 11128544, 10387789, 9470285).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 8, 1, 2)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 13, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4)).removeSpawns(EntityType.ZOMBIE, EntityType.WOLF).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.FLOWER_FOREST).changeColors(12906239, 3902136, 2388383, 7715315, 11393889, 10407783).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("flower_forest"), NMLPlacedFeatures.flowerBed("flower_forest"), NMLPlacedFeatures.feature("patch_peony"))).removeFeatures(VegetationPlacements.FLOWER_FOREST_FLOWERS, VegetationPlacements.FLOWER_FLOWER_FOREST, VegetationPlacements.PATCH_PUMPKIN).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 8, 3, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 12, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.COW, 6, 3, 4), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 10, 3, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.FOX, 5, 4, 4)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.FOREST).changeColors(12906239, 3902136, 2388383, 7715315, 8497229, 8363073).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.trees("forest_noise"), NMLPlacedFeatures.flowers("forest"), NMLPlacedFeatures.flowerBed("white_and_yellow"), NMLPlacedFeatures.patch("peony_and_lilac"))).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 5, 3, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 16, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.COW, 4, 3, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 3, 6)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.FOREST_FLOWERS).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.FROZEN_OCEAN).changeColors(15200511, 4220592, 2771621, 8431871, 10205860, 5541228).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"))).removeFeatures(VegetationPlacements.PATCH_PUMPKIN, VegetationPlacements.PATCH_SUGAR_CANE).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.FROZEN_PEAKS).changeColors(15200511, 4220592, 2771621, 8431871, 10205860, 5541228).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 1, 2)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.FROZEN_RIVER).changeColors(15200511, 4220592, 2771621, 10797823, 10205860, 5541228).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"))).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 1, 2)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_GRASS_BADLANDS).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.GROVE).changeColors(15200511, 4220592, 2771621, 7715315, 10205860, 10205860).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"))).removeFeatures(VegetationPlacements.PATCH_PUMPKIN, VegetationPlacements.PATCH_SUGAR_CANE).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.WOLF, 3, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 12, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.FOX, 7, 2, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 1, 2)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.ICE_SPIKES).changeColors(15200511, 4220592, 2771621, 8431871, 10205860, 5541228).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"))).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 1, 2)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.JAGGED_PEAKS).changeColors(15200511, 3899064, 2386591, 7715315, 10205860, 5541228).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.JUNGLE).changeColors(11071699, 2403207, 1479552, 7194319, 6798649, 6203171).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowerBed("jungle"), NMLPlacedFeatures.patch("duckweed_sparse"), NMLPlacedFeatures.patch("hearty_succulent"), VegetationPlacements.PATCH_LARGE_FERN)).removeFeatures(VegetationPlacements.PATCH_PUMPKIN).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 16, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PANDA, 4, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 8, 1, 3)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.FROG, 8, 3, 5)).removeSpawns(EntityType.SHEEP).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.LUKEWARM_OCEAN).changeColors(12711423, 3906239, 2979747, 6800872, 9419352, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.LUSH_CAVES).changeColors(11071699, 5536348, 2897190, 8103167, 11851346, 11851346).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.feature("underground/patch_duckweed_lush_caves"))).addFeatures(new FeatureWithStep(NMLPlacedFeatures.feature("underground/tortoise_burrows/tortoise_burrow_lush"), GenerationStep.Decoration.TOP_LAYER_MODIFICATION)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.MANGROVE_SWAMP).changeColors(11333800, 3832426, 5077600, 7194319, 0, 9285927).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.patch("water_mosaic"))).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.MEADOW).changeColors(12639487, 3895992, 2386591, 8431871, 8501355, 6465351).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowerBed("white_and_violet"), NMLPlacedFeatures.patch("field_mushroom_extra"), NMLPlacedFeatures.feature("clover_patch_meadow"), NMLPlacedFeatures.feature("field_mushroom_circle_meadow"), VegetationPlacements.BROWN_MUSHROOM_NORMAL, VegetationPlacements.RED_MUSHROOM_NORMAL)).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.DONKEY, 1, 1, 2)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS).changeColors(0xE6E6FF, 8616598, 5921653, 8898024, 11772555, 10583946).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.patch("mycelium_growths"), NMLPlacedFeatures.patch("duckweed_sparse"), VegetationPlacements.PATCH_DEAD_BUSH, NMLPlacedFeatures.patch("dried_grass_mycelium"))).addFeatures(new FeatureWithStep(NMLPlacedFeatures.feature("crag_rock_mycelium"), GenerationStep.Decoration.LOCAL_MODIFICATIONS)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.FROG, 4, 3, 5)).removeFeatures(MiscOverworldPlacements.DISK_SAND, MiscOverworldPlacements.DISK_GRAVEL, VegetationPlacements.PATCH_SUGAR_CANE, VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.OCEAN).changeColors(12906239, 3902136, 2388383, 7715315, 9680231, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.OLD_GROWTH_BIRCH_FOREST).changeColors(14411213, 3902136, 2388383, 7715315, 12300634, 6594108).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.trees("old_growth_birch"), NMLPlacedFeatures.flowers("old_growth_birch"), NMLPlacedFeatures.flowerBed("yellow"))).removeFeatures(VegetationPlacements.FOREST_FLOWERS, VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.BIRCH_TALL).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 4, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.COW, 2, 4, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 3, 4), new MobSpawnSettings.SpawnerData(EntityType.FOX, 2, 2, 6)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.OLD_GROWTH_PINE_TAIGA).changeColors(12639487, 3899064, 2386591, 8431871, 9149532, 8292172).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("taiga"), NMLPlacedFeatures.flowerBed("taiga"), NMLPlacedFeatures.patch("rose_bush"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_DEAD_BUSH, MiscOverworldPlacements.FOREST_ROCK).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.WOLF, 9, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 12, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 95, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 5, 1, 1)).removeSpawns(EntityType.COW).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.OLD_GROWTH_SPRUCE_TAIGA).changeColors(12639487, 3899064, 2386591, 8431871, 9149532, 8292172).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("taiga"), NMLPlacedFeatures.flowerBed("taiga"), NMLPlacedFeatures.patch("rose_bush"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, MiscOverworldPlacements.FOREST_ROCK).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.WOLF, 9, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 12, 2, 3)).removeSpawns(EntityType.COW).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.PLAINS).changeColors(12906239, 3902136, 2388383, 7715315, 9419352, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("plains"), NMLPlacedFeatures.flowerBed("white_and_yellow"))).removeFeatures(VegetationPlacements.FLOWER_PLAINS).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 16, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 14, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 14, 3, 6)).removeSpawns(EntityType.CHICKEN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.RIVER).changeColors(12906239, 3902136, 2388383, 7715315, 9680231, 8960833).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"), VegetationPlacements.PATCH_GRASS_NORMAL)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_GRASS_BADLANDS).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SAVANNA).changeColors(12711423, 3906239, 2979747, 6800872, 13415770, 10067503).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("savanna"), NMLPlacedFeatures.flowerBed("savanna"), NMLPlacedFeatures.patch("barrel_cactus_normal"), NMLPlacedFeatures.patch("succulent_normal"))).removeFeatures(VegetationPlacements.FLOWER_WARM).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 14, 2, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 8)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SAVANNA_PLATEAU).changeColors(12711423, 3906239, 2979747, 6800872, 13415770, 10067503).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("savanna"), NMLPlacedFeatures.flowerBed("savanna"), NMLPlacedFeatures.patch("barrel_cactus_normal"), NMLPlacedFeatures.patch("succulent_normal"))).removeFeatures(VegetationPlacements.FLOWER_WARM).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 14, 4, 4)).removeSpawns(EntityType.ARMADILLO).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SNOWY_BEACH).changeColors(15200511, 4220592, 2771621, 10797823, 10205860, 5541228).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"), VegetationPlacements.TREES_WATER)).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SNOWY_PLAINS).changeColors(15200511, 4220592, 2771621, 10797823, 10205860, 5541228).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("frosted"), NMLPlacedFeatures.flowerBed("frosted"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SNOWY_SLOPES).changeColors(15200511, 4220592, 2771621, 7715315, 10205860, 10205860).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SNOWY_TAIGA).changeColors(15200511, 4220592, 2771621, 10797823, 10205860, 13415770).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.trees("snowy_taiga"), NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("frosted"), NMLPlacedFeatures.patch("grass_snowy"), VegetationPlacements.PATCH_BERRY_COMMON)).removeFeatures(VegetationPlacements.TREES_TAIGA, VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_GRASS_TAIGA_2, VegetationPlacements.PATCH_BERRY_RARE).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 12, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.FOX, 10, 2, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 2, 1, 3)).removeSpawns(EntityType.PIG, EntityType.COW).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SPARSE_JUNGLE).changeColors(13107185, 3517088, 55668872, 7192271, 8174674, 7516981).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_JUNGLE, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowerBed("jungle"), NMLPlacedFeatures.patch("hearty_succulent"))).removeFeatures(VegetationPlacements.PATCH_PUMPKIN).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 12, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 10, 4, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.PARROT, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 6, 1, 3)).removeSpawns(EntityType.SHEEP).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.STONY_PEAKS).changeColors(12906239, 3902136, 2388383, 7715315, 9620606, 9098883).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("birch_forest"))).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.GOAT, 7, 1, 3)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.STONY_SHORE).changeColors(12906239, 3902136, 2388383, 7715315, 9680231, 8960833).addFeatures(new FeatureWithStep(NMLPlacedFeatures.feature("pond_stony_shore"), localModifications), new FeatureWithStep(NMLPlacedFeatures.feature("tuff_boulder"), GenerationStep.Decoration.UNDERGROUND_DECORATION)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("white"), NMLPlacedFeatures.flowerBed("white"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 5, 1, 3)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SUNFLOWER_PLAINS).changeColors(12906239, 3902136, 2388383, 7715315, 9943640, 10334529).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.trees("sunflower_plains"), NMLPlacedFeatures.flowers("sunflower_plains"), NMLPlacedFeatures.flowerBed("yellow"))).removeFeatures(VegetationPlacements.TREES_PLAINS, VegetationPlacements.FLOWER_PLAINS).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 16, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 14, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 8, 3, 6)).removeSpawns(EntityType.CHICKEN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.SWAMP).changeColors(0xA7CCA7, 5536348, 2897190, 7715315, 6975545).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 16, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 6, 4, 4)).addFeatures(FeatureWithStep.vegetationFeatures(VegetationPlacements.PATCH_PUMPKIN)).removeFeatures(VegetationPlacements.PATCH_PUMPKIN).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.TAIGA).changeColors(12639487, 3899064, 2386591, 8431871, 8035940, 8292172).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("taiga"), NMLPlacedFeatures.flowerBed("taiga"), NMLPlacedFeatures.patch("rose_bush"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 14, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 4, 8), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 12, 2, 3)).removeSpawns(EntityType.COW).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WARM_OCEAN).changeColors(12711423, 4106959, 3048361, 6800872, 8174674, 7516981).addFeatures(FeatureWithStep.vegetationFeatures(VegetationPlacements.FLOWER_WARM, NMLPlacedFeatures.flowerBed("jungle"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WINDSWEPT_FOREST).changeColors(12639487, 3902136, 2388383, 8431871, 9088126, 8032098).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_MEADOW, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("windswept"), NMLPlacedFeatures.flowerBed("white_and_violet"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 8, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.GOAT, 3, 2, 4)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WINDSWEPT_GRAVELLY_HILLS).changeColors(12639487, 3902136, 2388383, 8431871, 9546631, 8032098).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_MEADOW, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("windswept"), NMLPlacedFeatures.flowerBed("white_and_violet"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 7, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 3, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 7, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.GOAT, 6, 2, 4)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WINDSWEPT_HILLS).changeColors(12639487, 3902136, 2388383, 8431871, 9088126, 8032098).changeMusic(new Music((Holder)SoundEvents.MUSIC_BIOME_MEADOW, 12000, 24000, false)).addFeatures(FeatureWithStep.vegetationFeatures(NMLPlacedFeatures.flowers("windswept"), NMLPlacedFeatures.flowerBed("white_and_violet"))).removeFeatures(VegetationPlacements.FLOWER_DEFAULT).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 8, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 4, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 5, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 7, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 8, 4, 6)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.GOAT, 4, 2, 4)).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA).changeColors(12711423, 3906239, 2979747, 6800872, 12164442, 8558386).addFeatures(FeatureWithStep.vegetationFeatures(VegetationPlacements.PATCH_TALL_GRASS, NMLPlacedFeatures.flowers("savanna"), NMLPlacedFeatures.flowerBed("savanna"), VegetationPlacements.PATCH_GRASS_SAVANNA, NMLPlacedFeatures.patch("barrel_cactus_normal"), NMLPlacedFeatures.patch("succulent_normal"))).removeFeatures(VegetationPlacements.TREES_WINDSWEPT_SAVANNA, VegetationPlacements.FLOWER_DEFAULT, VegetationPlacements.PATCH_GRASS_NORMAL).changeSpawns(new MobSpawnSettings.SpawnerData(EntityType.PIG, 8, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 12, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 5, 4, 4)).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.GOAT, 6, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 8, 4, 4)).removeSpawns(EntityType.SHEEP, EntityType.ARMADILLO).build(this.featureToBiomes);
        this.modifyBiome((ResourceKey<Biome>)Biomes.WOODED_BADLANDS).changeColors(15322281, 4106959, 3048361, 11128544, 10387789, 9470285).addSpawns(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 5, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 8, 2, 8)).removeSpawns(EntityType.ZOMBIE).build(this.featureToBiomes);
        this.addFeaturesToTag(NMLTags.HAS_CACTUS, vegetalDecoration, NMLPlacedFeatures.patch("barrel_cactus_desert"), NMLPlacedFeatures.patch("succulent_desert"), NMLPlacedFeatures.flowers("all_tulips"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_OVERWORLD_FOLIAGE, vegetalDecoration, NMLPlacedFeatures.patch("grass_sprouts_normal"), NMLPlacedFeatures.patch("roots"), NMLPlacedFeatures.patch("cattail"), NMLPlacedFeatures.patch("reeds"), NMLPlacedFeatures.patch("waterlily_common"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_SWAMP_FOLIAGE, vegetalDecoration, NMLPlacedFeatures.patch("duckweed"), NMLPlacedFeatures.patch("pickleweed"), NMLPlacedFeatures.patch("reeds_swamp"), NMLPlacedFeatures.patch("cattail_swamp"));
        this.addFeaturesToTag(NMLTags.IS_SHORELINE, vegetalDecoration, NMLPlacedFeatures.feature("seashells"));
        this.addFeaturesToTag(NMLTags.IS_CRAGLAND, localModifications, NMLPlacedFeatures.feature("crag_rock_craglands"));
        this.addFeaturesToTag(NMLTags.IS_OCEANIC_CRAGLAND, localModifications, NMLPlacedFeatures.feature("crag_rock_ocean"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_BEACHGRASS, vegetalDecoration, NMLPlacedFeatures.patch("beachgrass"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_CAVE_WEEDS, vegetalDecoration, NMLPlacedFeatures.feature("underground/patch_cave_weeds"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_CLOVERS, vegetalDecoration, NMLPlacedFeatures.feature("clover_patch"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_DRIED_GRASS, vegetalDecoration, NMLPlacedFeatures.patch("dried_grass"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FERN_PATCH, vegetalDecoration, NMLPlacedFeatures.patch("fern_forest"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FIDDLEHEAD, vegetalDecoration, NMLPlacedFeatures.patch("fiddlehead"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FIELD_MUSHROOM, vegetalDecoration, NMLPlacedFeatures.patch("field_mushroom_normal"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FROSTED_GRASS_FOREST, vegetalDecoration, NMLPlacedFeatures.patch("frosted_grass_forest"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FROSTED_GRASS_PLAINS, vegetalDecoration, NMLPlacedFeatures.patch("frosted_grass_plains"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_ICICLES, vegetalDecoration, NMLPlacedFeatures.patch("icicles"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_OAT_GRASS, vegetalDecoration, NMLPlacedFeatures.feature("oat_grass_patch"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_RAFFLESIA, vegetalDecoration, NMLPlacedFeatures.patch("rafflesia"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_GROUND_IVY, vegetalDecoration, NMLPlacedFeatures.feature("ground_ivy_patch"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FALLEN_TREES_DRY, vegetalDecoration, NMLPlacedFeatures.feature("fallen_tree_dry"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FALLEN_TREES_FOREST, vegetalDecoration, NMLPlacedFeatures.feature("fallen_tree_forest"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FALLEN_TREES_JUNGLE, vegetalDecoration, NMLPlacedFeatures.feature("fallen_tree_jungle"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FALLEN_TREES_SNOWY, vegetalDecoration, NMLPlacedFeatures.feature("fallen_tree_snowy"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FALLEN_TREES_SPARSE, vegetalDecoration, NMLPlacedFeatures.feature("fallen_tree_sparse"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_PEBBLES, localModifications, NMLPlacedFeatures.feature("pebbles"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FOREST_ROCK, localModifications, MiscOverworldPlacements.FOREST_ROCK);
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_STONE_BOULDER, localModifications, NMLPlacedFeatures.feature("stone_boulder"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_POND_COMMON, localModifications, NMLPlacedFeatures.feature("pond_common"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_POND_COMMON_SNOWY, localModifications, NMLPlacedFeatures.feature("pond_common_snowy"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_POND_SWAMP, localModifications, NMLPlacedFeatures.feature("pond_swamp"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_QUARTZITE_GEODE, localModifications, NMLPlacedFeatures.feature("underground/quartzite_geode"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_NETHER_QUARTZITE_GEODE, localModifications, NMLPlacedFeatures.feature("underground/nether_quartzite_geode"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_MUD_PATCH, GenerationStep.Decoration.FLUID_SPRINGS, NMLPlacedFeatures.feature("mud_patch"));
        this.addFeaturesToTag(NMLTags.HAS_GRAVEL_SHORE, localModifications, NMLPlacedFeatures.feature("gravel_decorator_pebble"), NMLPlacedFeatures.feature("gravel_decorator_boulder"), NMLPlacedFeatures.feature("gravel_decorator_pond"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_FIELD_MUSHROOM_CIRCLE, vegetalDecoration, NMLPlacedFeatures.feature("field_mushroom_circle"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_SHELF_MUSHROOM_FOREST, vegetalDecoration, NMLPlacedFeatures.feature("shelf_mushroom_forest"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_SHELF_MUSHROOM_OLD_GROWTH, vegetalDecoration, NMLPlacedFeatures.feature("shelf_mushroom_old_growth"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.HAS_SHELF_MUSHROOM_TAIGA, vegetalDecoration, NMLPlacedFeatures.feature("shelf_mushroom_taiga"));
        this.addFeaturesToTag(NMLTags.FeatureAddition.REGULAR_TORTOISE_BURROWS, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, NMLPlacedFeatures.feature("underground/tortoise_burrows/tortoise_burrow"));
        this.processFeatures();
    }

    private BiomeModifierBuilder modifyBiome(ResourceKey<Biome> biome) {
        return new BiomeModifierBuilder(this.bootstrap, biome);
    }

    @SafeVarargs
    private void addFeaturesToTag(TagKey<Biome> biomeTag, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        ArrayList featureHolders = new ArrayList();
        List.of(features).forEach(featureKey -> featureHolders.add(this.bootstrap.lookup(Registries.PLACED_FEATURE).getOrThrow(featureKey)));
        String name = biomeTag.location().getPath() + "_tag_features";
        this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location("add_" + name)), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)this.bootstrap.lookup(Registries.BIOME).getOrThrow(biomeTag), (HolderSet)HolderSet.direct(featureHolders), step));
    }

    private void processFeatures() {
        this.featureToBiomes.forEach((feature, biomeSet) -> {
            HolderSet.Direct mergedBiomes = HolderSet.direct((List)biomeSet);
            this.addFeatureToSet((FeatureWithStep)feature, (HolderSet<Biome>)mergedBiomes);
        });
    }

    private void addFeatureToSet(FeatureWithStep feature, HolderSet<Biome> biomes) {
        Holder.Reference placedFeature = this.bootstrap.lookup(Registries.PLACED_FEATURE).getOrThrow(feature.key());
        this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location("add_" + ((ResourceKey)placedFeature.unwrapKey().orElseThrow()).location().getPath())), (Object)new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature}), feature.step()));
    }
}

