/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen;

import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class NMLBlockStateProvider
extends BlockStateProvider {
    public NMLBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "nomansland", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithVariation((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICKS.get(), i -> {
            String name = this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_" + i;
            return this.models().cubeAll(this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_" + i, this.modLoc("block/" + name));
        }, 6);
        this.simpleBlockItem((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICKS.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_0")));
        this.slabBlockWithVariation((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICK_SLAB.get(), i -> this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_" + i), i -> this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_" + i), 6);
        this.simpleBlockItem((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICK_SLAB.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICK_SLAB) + "_0")));
        this.stairsBlockWithVariation((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICK_STAIRS.get(), i -> this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_" + i), 6);
        this.simpleBlockItem((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICK_STAIRS.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICK_STAIRS) + "_0")));
        this.wallBlock((WallBlock)NMLBlocks.COBBLED_DEEPSLATE_BRICK_WALL.get(), this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_0"));
        this.simpleBlockItem((Block)NMLBlocks.COBBLED_DEEPSLATE_BRICK_WALL.get(), (ModelFile)this.models().wallInventory(this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICK_WALL) + "_inventory", this.modLoc("block/" + this.name(NMLBlocks.COBBLED_DEEPSLATE_BRICKS) + "_0")));
    }

    public void flatBlockItem(Block block) {
        this.flatBlockItem(block, this.modLoc("block/" + this.name(block)));
    }

    public void flatBlockItem(Block block, ResourceLocation texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void simpleBlockWithVariation(Block block, int variations) {
        String blockName = this.name(block);
        this.simpleBlockWithVariation(block, i -> {
            String name = blockName + "_" + i;
            return this.models().cubeAll(name, this.modLoc("block/" + name));
        }, variations);
    }

    private void simpleBlockWithVariation(Block block, Function<Integer, ModelBuilder> modelFactory, int variations) {
        for (int i = 0; i < variations; ++i) {
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)modelFactory.apply(i)).buildLast()});
        }
    }

    private void simpleBlockWithVariationAndTransformation(Block block, int variations, boolean rotateX, boolean rotateY) {
        String blockName = this.name(block);
        this.simpleBlockWithVariationAndTransformation(block, i -> {
            String suffix = "_" + i;
            return this.models().cubeAll(blockName + suffix, this.modLoc("block/" + blockName + suffix));
        }, i -> {
            String suffix = "_" + i;
            return this.models().singleTexture(blockName + suffix + "_mirrored", this.mcLoc("block/cube_mirrored_all"), "all", this.modLoc("block/" + blockName + suffix));
        }, variations, rotateX, rotateY);
    }

    private void simpleBlockWithVariationAndTransformation(Block block, Function<Integer, ModelBuilder> modelFactory, Function<Integer, ModelBuilder> mirroredModelFactory, int variations, boolean rotateX, boolean rotateY) {
        int i;
        ModelBuilder[] models = new ModelBuilder[variations * 2];
        for (i = 0; i < variations; ++i) {
            models[i * 2] = modelFactory.apply(i);
            models[i * 2 + 1] = mirroredModelFactory.apply(i);
        }
        for (i = 0; i < variations; ++i) {
            int rot;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)models[i * 2]).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)models[i * 2 + 1]).buildLast()});
            if (rotateX && rotateY) {
                for (int rotX = 1; rotX < 4; ++rotX) {
                    for (int rotY = 0; rotY < 4; ++rotY) {
                        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)models[i * 2]).rotationX(rotX * 90).rotationY(rotY * 90).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)models[i * 2 + 1]).rotationX(rotX * 90).rotationY(rotY * 90).buildLast()});
                    }
                }
                continue;
            }
            if (rotateX) {
                for (rot = 1; rot < 4; ++rot) {
                    this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)models[i * 2]).rotationX(rot * 90).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)models[i * 2 + 1]).rotationX(rot * 90).buildLast()});
                }
                continue;
            }
            if (!rotateY) continue;
            for (rot = 1; rot < 4; ++rot) {
                this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)models[i * 2]).rotationY(rot * 90).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)models[i * 2 + 1]).rotationY(rot * 90).buildLast()});
            }
        }
    }

    private void slabBlockWithVariation(Block block, Function<Integer, ResourceLocation> doubleSlabFactory, Function<Integer, ResourceLocation> texFactory, int variations) {
        this.slabBlockWithVariation(block, doubleSlabFactory, texFactory, texFactory, texFactory, variations);
    }

    private void slabBlockWithVariation(Block block, Function<Integer, ResourceLocation> doubleSlabFactory, Function<Integer, ResourceLocation> sideTexFactory, Function<Integer, ResourceLocation> bottomTexFactory, Function<Integer, ResourceLocation> topTexFactory, int variations) {
        String blockName = this.name(block);
        for (int i = 0; i < variations; ++i) {
            String suffix = "_" + i;
            ResourceLocation sideTex = sideTexFactory.apply(i);
            ResourceLocation bottomTex = bottomTexFactory.apply(i);
            ResourceLocation topTex = topTexFactory.apply(i);
            this.getVariantBuilder(block).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(doubleSlabFactory.apply(i)))}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().slab(blockName + suffix, sideTex, bottomTex, topTex))}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().slabTop(blockName + "_top" + suffix, sideTex, bottomTex, topTex))});
        }
    }

    private void stairsBlockWithVariation(Block block, Function<Integer, ResourceLocation> texFactory, int variations) {
        this.stairsBlockWithVariation(block, texFactory, texFactory, texFactory, variations);
    }

    private void stairsBlockWithVariation(Block block, Function<Integer, ResourceLocation> sideTexFactory, Function<Integer, ResourceLocation> bottomTexFactory, Function<Integer, ResourceLocation> topTexFactory, int variations) {
        ModelFile[] stairs = new ModelFile[variations];
        ModelFile[] stairsInner = new ModelFile[variations];
        ModelFile[] stairsOuter = new ModelFile[variations];
        String blockName = this.name(block);
        for (int i = 0; i < variations; ++i) {
            String suffix = "_" + i;
            ResourceLocation sideTex = sideTexFactory.apply(i);
            ResourceLocation bottomTex = bottomTexFactory.apply(i);
            ResourceLocation topTex = topTexFactory.apply(i);
            stairs[i] = this.models().stairs(blockName + suffix, sideTex, bottomTex, topTex);
            stairsInner[i] = this.models().stairsInner(blockName + "_inner" + suffix, sideTex, bottomTex, topTex);
            stairsOuter[i] = this.models().stairsOuter(blockName + "_outer" + suffix, sideTex, bottomTex, topTex);
        }
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            for (int i = 0; i < variations; ++i) {
                if (i > 0) {
                    builder = builder.nextModel();
                }
                builder = builder.modelFile(shape == StairsShape.STRAIGHT ? stairs[i] : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner[i] : stairsOuter[i])).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock);
            }
            return builder.build();
        }, new Property[]{StairBlock.WATERLOGGED});
    }

    public ModelBuilder cubeBottomTopMirrored(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.cubeMirrored(name, bottom, top, side, side, side, side);
    }

    public ModelBuilder cubeMirrored(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "cube_mirrored")).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west);
    }

    public ModelBuilder cross(Block block) {
        return this.models().cross(this.name(block), this.modLoc("block/" + this.name(block)));
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private String name(BlockDefinition block) {
        return this.key(block.block()).getPath();
    }
}

