/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.surfacerule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public record BelowOrEqualToYConditionSource(VerticalAnchor anchor, boolean useSurfacePosition, float noiseMultiplier, float offset) implements SurfaceRules.ConditionSource
{
    public static final KeyDispatchDataCodec<BelowOrEqualToYConditionSource> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(record -> record.group((App)VerticalAnchor.CODEC.fieldOf("anchor").forGetter(BelowOrEqualToYConditionSource::anchor), (App)Codec.BOOL.fieldOf("use_surface_position").forGetter(BelowOrEqualToYConditionSource::useSurfacePosition), (App)Codec.FLOAT.fieldOf("noise_multiplier").forGetter(BelowOrEqualToYConditionSource::noiseMultiplier), (App)Codec.FLOAT.fieldOf("offset").orElse((Object)Float.valueOf(0.0f)).forGetter(BelowOrEqualToYConditionSource::offset)).apply((Applicative)record, BelowOrEqualToYConditionSource::new)));

    public SurfaceRules.Condition apply(SurfaceRules.Context surfaceRulesContext) {
        return new YCondition(surfaceRulesContext, this.anchor, this.useSurfacePosition, this.noiseMultiplier, this.offset);
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> codec() {
        return CODEC;
    }

    static class YCondition
    extends SurfaceRules.LazyYCondition {
        private final VerticalAnchor anchor;
        private final boolean useSurfacePosition;
        private final float surfaceNoiseMultiplier;
        private final float offset;

        YCondition(SurfaceRules.Context surfaceRulesContext, VerticalAnchor anchor, boolean useSurfacePosition, float surfaceNoiseMultiplier, float offset) {
            super(surfaceRulesContext);
            this.anchor = anchor;
            this.useSurfacePosition = useSurfacePosition;
            this.surfaceNoiseMultiplier = surfaceNoiseMultiplier;
            this.offset = offset;
        }

        protected boolean compute() {
            float y = (float)this.context.blockY + this.offset;
            if (this.useSurfacePosition) {
                y += (float)this.context.stoneDepthAbove;
            }
            return (y += ((float)this.context.surfaceDepth - 2.5f) / 2.5f * this.surfaceNoiseMultiplier) + this.offset <= (float)this.anchor.resolveY(this.context.context);
        }
    }
}

