/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.structure.processor;

import com.farcr.nomansland.common.registry.worldgen.NMLStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class PrefixProcessor
extends StructureProcessor {
    public static final MapCodec<PrefixProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("prefix").forGetter(prefixProcessor -> prefixProcessor.prefix), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(prefixProcessor -> Float.valueOf(prefixProcessor.chance))).apply((Applicative)instance, PrefixProcessor::new));
    private final float chance;
    private final String prefix;

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)NMLStructureProcessorTypes.PREFIX.get();
    }

    public PrefixProcessor(String prefix, float chance) {
        this.prefix = prefix;
        this.chance = chance;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = relativeBlockInfo.state();
        Registry blockRegistry = levelReader.registryAccess().registryOrThrow(Registries.BLOCK);
        Optional block = blockRegistry.getOptional(blockRegistry.getKey((Object)state.getBlock()).withPrefix(this.prefix + "_"));
        if (block.isPresent() && settings.getRandom(relativeBlockInfo.pos()).nextFloat() < this.chance) {
            BlockState prefixedBlockState = ((Block)block.get()).withPropertiesOf(state);
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), prefixedBlockState, relativeBlockInfo.nbt());
        }
        return relativeBlockInfo;
    }
}

