/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.generation;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import com.farcr.nomansland.common.world.surfacerule.AndConditionSource;
import com.farcr.nomansland.common.world.surfacerule.BelowOrEqualToYConditionSource;
import com.farcr.nomansland.common.world.surfacerule.BiomeTagConditionSource;
import com.terraformersmc.biolith.api.surface.SurfaceGeneration;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.neoforge.common.Tags;

public class NMLSurfaceRules {
    private static final SurfaceRules.RuleSource COARSE_DIRT = NMLSurfaceRules.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource PODZOL = NMLSurfaceRules.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource MUD = NMLSurfaceRules.makeStateRule(Blocks.MUD);
    private static final SurfaceRules.RuleSource SILT = NMLSurfaceRules.makeStateRule((Block)NMLBlocks.SILT.get());
    private static final SurfaceRules.RuleSource WATER = NMLSurfaceRules.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource GRAVEL = NMLSurfaceRules.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SAND = NMLSurfaceRules.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource SNOW_BLOCK = NMLSurfaceRules.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource PACKED_ICE = NMLSurfaceRules.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource ICE = NMLSurfaceRules.makeStateRule(Blocks.ICE);
    private static final SurfaceRules.RuleSource SANDSTONE_UNDER_SAND = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SAND), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.SANDSTONE.defaultBlockState()))});
    private static final SurfaceRules.RuleSource DEEP_GRAVEL = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.GRAVEL.defaultBlockState()))});
    private static final SurfaceRules.RuleSource CLASSIC_SOIL = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)NMLSurfaceRules.makeStateRule(Blocks.GRASS_BLOCK)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.DIRT.defaultBlockState()))});
    private static final SurfaceRules.ConditionSource BEACH = new AndConditionSource(new BelowOrEqualToYConditionSource(VerticalAnchor.absolute((int)69), true, 1.5f, 0.5f), SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)53), (int)2));
    private static final SurfaceRules.ConditionSource SHORE = new AndConditionSource(new BelowOrEqualToYConditionSource(VerticalAnchor.absolute((int)65), true, 1.0f, 0.75f), SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)53), (int)2));

    public static void register() {
        SurfaceRules.RuleSource gravel_shores = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)new BiomeTagConditionSource(NMLTags.HAS_GRAVEL_SHORE), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SHORE, (SurfaceRules.RuleSource)GRAVEL));
        SurfaceRules.RuleSource mud_shores = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)new BiomeTagConditionSource(Tags.Biomes.IS_SWAMP), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SHORE, (SurfaceRules.RuleSource)MUD));
        SurfaceRules.RuleSource jungle = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JUNGLE}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)COARSE_DIRT));
        SurfaceRules.RuleSource darkForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DARK_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL));
        SurfaceRules.RuleSource autumnalForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.AUTUMNAL_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)}));
        SurfaceRules.RuleSource mapleForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.MAPLE_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL));
        SurfaceRules.RuleSource oldGrowthForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.OLD_GROWTH_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)COARSE_DIRT));
        SurfaceRules.RuleSource frozenWoods = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.FROZEN_WOODS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(2.25), (SurfaceRules.RuleSource)SNOW_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.5), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)SILT)}));
        SurfaceRules.RuleSource bog = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.BOG}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER))));
        SurfaceRules.RuleSource bayou = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.BAYOU}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)PODZOL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource darkSwamp = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.DARK_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource stonyShore = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.9), (SurfaceRules.RuleSource)SILT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.7), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)SILT), GRAVEL})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.45), (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)GRAVEL))}));
        SurfaceRules.RuleSource mushroom_fields = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MUSHROOM_FIELDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BEACH, (SurfaceRules.RuleSource)SILT));
        SurfaceRules.RuleSource downfall_isle = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.DOWNFALL_ISLE}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BEACH, (SurfaceRules.RuleSource)GRAVEL));
        SurfaceRules.RuleSource lush_river = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.LUSH_RIVER}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource blackwater_river = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.BLACKWATER_RIVER}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.75), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource desert_river = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.DESERT_RIVER}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)BEACH), (SurfaceRules.RuleSource)SANDSTONE_UNDER_SAND));
        SurfaceRules.RuleSource mud_beach = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.MUD_BEACH}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BEACH, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.MUD.defaultBlockState()))));
        SurfaceRules.RuleSource frozen_shore = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.FROZEN_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.9), (SurfaceRules.RuleSource)SILT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.7), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)SILT), GRAVEL})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.45), (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)GRAVEL))}));
        SurfaceRules.RuleSource tropical_beach = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.TROPICAL_BEACH}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BEACH, (SurfaceRules.RuleSource)SANDSTONE_UNDER_SAND));
        SurfaceRules.RuleSource caves = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.CAVES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.STONE.defaultBlockState())));
        SurfaceRules.RuleSource cave_depths = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.CAVE_DEPTHS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.DEEPSLATE.defaultBlockState())));
        SurfaceGeneration.addOverworldSurfaceRules((ResourceLocation)NoMansLand.location("rules/overworld"), (SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{gravel_shores, mud_shores, mushroom_fields, downfall_isle, desert_river, mud_beach, tropical_beach}), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{jungle, darkForest, autumnalForest, mapleForest, oldGrowthForest, frozenWoods, bog, bayou, darkSwamp, stonyShore, frozen_shore, lush_river, blackwater_river}))})), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{caves, cave_depths})});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }
}

