/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.worldgen.NMLTreeDecoratorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HugeShelfMushroomDecorator
extends TreeDecorator {
    public static final MapCodec<HugeShelfMushroomDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(f -> Float.valueOf(f.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("limit").forGetter(f -> f.limit), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_bottom").forGetter(f -> f.exclusionBottom), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_top").forGetter(f -> f.exclusionTop)).apply((Applicative)instance, HugeShelfMushroomDecorator::new));
    protected final float probability;
    protected final int limit;
    protected final int exclusionBottom;
    protected final int exclusionTop;

    public HugeShelfMushroomDecorator(float probability, int limit, int exclusionBottom, int exclusionTop) {
        this.probability = probability;
        this.limit = limit;
        this.exclusionBottom = exclusionBottom;
        this.exclusionTop = exclusionTop;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)NMLTreeDecoratorTypes.HUGE_SHELF_MUSHROOM.get();
    }

    public void place(TreeDecorator.Context context) {
        HashSet<BlockPos> excludedPositions = new HashSet<BlockPos>();
        int logs = 0;
        RandomSource random = context.random();
        Optional<BlockPos> bottomLog = context.logs().stream().min(Comparator.comparingInt(Vec3i::getY));
        Optional<BlockPos> topLog = context.logs().stream().max(Comparator.comparingInt(Vec3i::getY));
        int minY = bottomLog.map(Vec3i::getY).orElse(-65);
        int maxY = topLog.map(Vec3i::getY).orElse(-65);
        for (BlockPos pos : Util.shuffledCopy((ObjectArrayList)context.logs(), (RandomSource)random)) {
            if (pos.getY() - minY >= this.exclusionBottom && maxY - pos.getY() >= this.exclusionTop && random.nextFloat() < this.probability && !excludedPositions.contains(pos)) {
                Direction dir = null;
                for (Direction dirTemp : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                    if (!context.isAir(pos.relative(dirTemp)) || !context.isAir(pos.relative(dirTemp.getClockWise())) || !context.isAir(pos.relative(dirTemp).relative(dirTemp.getClockWise()))) continue;
                    dir = dirTemp;
                    break;
                }
                if (dir != null) {
                    context.setBlock(pos.relative(dir), ((SlabBlock)NMLBlocks.SHELF_MUSHROOM_BLOCK.get()).defaultBlockState());
                    context.setBlock(pos.relative(dir.getClockWise()), ((SlabBlock)NMLBlocks.SHELF_MUSHROOM_BLOCK.get()).defaultBlockState());
                    context.setBlock(pos.relative(dir).relative(dir.getClockWise()), ((SlabBlock)NMLBlocks.SHELF_MUSHROOM_BLOCK.get()).defaultBlockState());
                    excludedPositions.add(pos);
                    ++logs;
                }
            }
            if (logs < this.limit) continue;
            break;
        }
    }
}

