/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.world.feature.FallenTreeFeatureConfiguration;
import com.farcr.nomansland.common.world.feature.decorator.FallenTreeDecorator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class FallenTreeFeature
extends Feature<FallenTreeFeatureConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FallenTreeFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        FallenTreeFeatureConfiguration config = (FallenTreeFeatureConfiguration)context.config();
        HashMap<Block, Integer> logScan = new HashMap<Block, Integer>();
        BlockPos.MutableBlockPos posMutable = origin.mutable();
        for (int x = -10; x <= 10; ++x) {
            for (int y = -10; y <= 10; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    posMutable.set((Vec3i)origin.offset(x, y, z));
                    BlockState blockState = level.getBlockState((BlockPos)posMutable);
                    if (!blockState.is(BlockTags.LOGS) || !blockState.hasProperty((Property)RotatedPillarBlock.AXIS) || !blockState.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)posMutable)) continue;
                    if (logScan.containsKey(blockState.getBlock())) {
                        logScan.put(blockState.getBlock(), (Integer)logScan.get(blockState.getBlock()) + 1);
                        continue;
                    }
                    logScan.put(blockState.getBlock(), 1);
                }
            }
        }
        if (logScan.isEmpty()) {
            return false;
        }
        int totalBlockCount = logScan.values().stream().mapToInt(i -> i).sum();
        Block blockChoice = null;
        for (Map.Entry entry : logScan.entrySet()) {
            if (random.nextInt(totalBlockCount) < (Integer)entry.getValue()) {
                blockChoice = (Block)entry.getKey();
                break;
            }
            totalBlockCount -= ((Integer)entry.getValue()).intValue();
        }
        if (blockChoice == null) {
            return false;
        }
        int gap = config.gap().sample(random);
        int size = config.size().sample(random);
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        HashSet<BlockPos> logPos = new HashSet<BlockPos>();
        ArrayList decoPos = new ArrayList();
        for (int i2 = 0; i2 < size; ++i2) {
            BlockPos pos = origin.relative(dir, gap + i2 + 1);
            if (!level.getBlockState(pos).is(BlockTags.REPLACEABLE) || !level.getBlockState(pos.below()).isSolid()) {
                return false;
            }
            logPos.add(pos);
        }
        if (!level.getBlockState(origin).is(BlockTags.REPLACEABLE) || !level.getBlockState(origin.below()).is(BlockTags.DIRT)) {
            return false;
        }
        for (BlockPos pos : logPos) {
            level.setBlock(pos, (BlockState)blockChoice.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()), 2);
        }
        if (random.nextFloat() < config.stumpProbability()) {
            level.setBlock(origin, blockChoice.defaultBlockState(), 2);
            logPos.add(origin);
        }
        BiConsumer<BlockPos, BlockState> decoratorConsumer = (pos1, state1) -> {
            decoPos.add(pos1.immutable());
            level.setBlock(pos1, state1, 19);
        };
        if (!config.decorators().isEmpty()) {
            FallenTreeDecorator.Context fallentreedecorator$context = new FallenTreeDecorator.Context(level, decoratorConsumer, random, logPos, context.chunkGenerator());
            config.decorators().forEach(deco -> deco.place(fallentreedecorator$context));
        }
        return true;
    }
}

