/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.block.BeardMossBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.worldgen.NMLTreeDecoratorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BeardMossDecorator
extends TreeDecorator {
    public static final MapCodec<BeardMossDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(f -> Float.valueOf(f.probability)), (App)IntProvider.codec((int)0, (int)16).fieldOf("size").forGetter(f -> f.size)).apply((Applicative)instance, BeardMossDecorator::new));
    protected final float probability;
    protected final IntProvider size;

    public BeardMossDecorator(float probability, IntProvider size) {
        this.probability = probability;
        this.size = size;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)NMLTreeDecoratorTypes.BEARD_MOSS.get();
    }

    public void place(TreeDecorator.Context context) {
        for (BlockPos pos : context.leaves()) {
            if (!context.level().isStateAtPosition(pos.below(), BlockBehaviour.BlockStateBase::isAir) || !(context.random().nextFloat() < this.probability)) continue;
            int placedSize = this.size.sample(context.random());
            for (int i = 1; i <= placedSize; ++i) {
                context.setBlock(pos.below(i), (BlockState)((BeardMossBlock)((Object)NMLBlocks.BEARD_MOSS.get())).defaultBlockState().setValue(BeardMossBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            }
            context.setBlock(pos.below(placedSize), (BlockState)((BeardMossBlock)((Object)NMLBlocks.BEARD_MOSS.get())).defaultBlockState().setValue(BeardMossBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        }
    }
}

