/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.densityfunction.modification;

import com.farcr.nomansland.common.world.densityfunction.modification.DensityFunctionModifications;
import com.farcr.nomansland.common.world.densityfunction.modification.DensityFunctionModifier;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.DensityFunction;

public class DensityFunctionRegistryCodec
extends RegistryFileCodec<DensityFunction> {
    public DensityFunctionRegistryCodec(Codec<DensityFunction> elementCodec) {
        super(Registries.DENSITY_FUNCTION, elementCodec, true);
    }

    public <T> DataResult<Pair<Holder<DensityFunction>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof RegistryOps) {
            RegistryOps registryops = (RegistryOps)ops;
            Optional optional = registryops.getter(this.registryKey);
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.registryKey));
            }
            HolderGetter registry = (HolderGetter)optional.get();
            DataResult dataresult = ResourceLocation.CODEC.decode(ops, input);
            if (dataresult.result().isEmpty()) {
                return this.elementCodec.decode(ops, input).map(dataResult -> dataResult.mapFirst(Holder::direct));
            }
            Pair pair = (Pair)dataresult.result().get();
            ResourceKey resourcekey = ResourceKey.create((ResourceKey)this.registryKey, (ResourceLocation)((ResourceLocation)pair.getFirst()));
            boolean hasModifier = DensityFunctionModifications.MODIFIERS.containsKey(resourcekey);
            return registry.get(resourcekey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(resourcekey))).map(holder -> Pair.of((Object)(hasModifier ? new ModifiedHolderWrapper((Holder<DensityFunction>)holder, DensityFunctionModifications.MODIFIERS.get(resourcekey)) : holder), (Object)pair.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.elementCodec.decode(ops, input).map(holder -> holder.mapFirst(Holder::direct));
    }

    public String toString() {
        return "ModifiedRegistryFileCodec[" + String.valueOf(this.registryKey) + " " + String.valueOf(this.elementCodec) + "]";
    }

    private static final class ModifiedHolderWrapper
    implements Holder<DensityFunction> {
        private final Holder<DensityFunction> wrapped;
        private final DensityFunctionModifier modifier;
        private DensityFunction modifiedValue;

        private ModifiedHolderWrapper(Holder<DensityFunction> wrapped, DensityFunctionModifier modifier) {
            this.wrapped = wrapped;
            this.modifier = modifier;
        }

        public DensityFunction value() {
            if (this.modifiedValue == null) {
                this.modifiedValue = this.modifier.visit((DensityFunction)this.wrapped.value());
            }
            return this.modifiedValue;
        }

        public boolean isBound() {
            return this.wrapped.isBound();
        }

        public boolean is(ResourceLocation location) {
            return this.wrapped.is(location);
        }

        public boolean is(ResourceKey<DensityFunction> resourceKey) {
            return this.wrapped.is(resourceKey);
        }

        public boolean is(Predicate<ResourceKey<DensityFunction>> predicate) {
            return this.wrapped.is(predicate);
        }

        public boolean is(TagKey<DensityFunction> tagKey) {
            return this.wrapped.is(tagKey);
        }

        public boolean is(Holder<DensityFunction> holder) {
            return this.wrapped.is(holder);
        }

        public Stream<TagKey<DensityFunction>> tags() {
            return this.wrapped.tags();
        }

        public Either<ResourceKey<DensityFunction>, DensityFunction> unwrap() {
            return this.wrapped.unwrap();
        }

        public Optional<ResourceKey<DensityFunction>> unwrapKey() {
            return this.wrapped.unwrapKey();
        }

        public Holder.Kind kind() {
            return this.wrapped.kind();
        }

        public boolean canSerializeIn(HolderOwner<DensityFunction> owner) {
            return this.wrapped.canSerializeIn(owner);
        }
    }

    private static class ModifiedReferenceHolder
    extends Holder.Reference<DensityFunction> {
        private final DensityFunctionModifier modifier;
        private boolean appliedModifier = false;

        protected ModifiedReferenceHolder(Holder.Reference<DensityFunction> holder, DensityFunctionModifier modifier) {
            super(holder.type, holder.owner, holder.key, (Object)((DensityFunction)holder.value));
            this.modifier = modifier;
        }

        public DensityFunction value() {
            if (this.value == null) {
                throw new IllegalStateException("Trying to access unbound value '" + String.valueOf(this.key) + "' from registry " + String.valueOf(this.owner));
            }
            if (!this.appliedModifier) {
                this.value = this.modifier.visit((DensityFunction)this.value);
                this.appliedModifier = true;
            }
            return (DensityFunction)super.value();
        }
    }
}

