/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record RangeSelectDensityFunction(DensityFunction input, double min, double max, double gradient) implements DensityFunctions.PureTransformer
{
    private static final MapCodec<RangeSelectDensityFunction> DATA_CODEC = RecordCodecBuilder.mapCodec(record -> record.group((App)DensityFunction.DIRECT_CODEC.fieldOf("input").forGetter(RangeSelectDensityFunction::input), (App)Codec.doubleRange((double)-1000000.0, (double)1000000.0).fieldOf("min").forGetter(RangeSelectDensityFunction::min), (App)Codec.doubleRange((double)-1000000.0, (double)1000000.0).fieldOf("max").forGetter(RangeSelectDensityFunction::max), (App)Codec.doubleRange((double)-1000000.0, (double)1000000.0).fieldOf("gradient").forGetter(RangeSelectDensityFunction::gradient)).apply((Applicative)record, RangeSelectDensityFunction::new));
    public static final KeyDispatchDataCodec<RangeSelectDensityFunction> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);

    public double transform(double value) {
        if (value < this.min + this.gradient) {
            return Mth.clampedMap((double)value, (double)this.min, (double)(this.min + this.gradient), (double)0.0, (double)1.0);
        }
        if (value > this.max - this.gradient) {
            return Mth.clampedMap((double)value, (double)(this.max - this.gradient), (double)this.max, (double)1.0, (double)0.0);
        }
        return 1.0;
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new RangeSelectDensityFunction(this.input.mapAll(visitor), this.min, this.max, this.gradient));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

